```json
{
  "title": "Interplanar Projector",
  "icon": "exposure:interplanar_projector",
  "associated_items": [
    "exposure:interplanar_projector",
    "exposure:broken_interplanar_projector"
  ],
  "categories": [
    "exposure:attachments"
  ]
}
```

&spotlight(exposure:interplanar_projector)
**Interplanar Projectors** are a special [filter](^exposure:filter) for the [Camera](^exposure_camera), that allows loading images from a file or URL.


You can use Projector without renaming it for a inverted color effect.

;;;;;

&title(Crafting)
<recipe;exposure:interplanar_projector>

;;;;;

&title(Usage)
To load the image - rename it in an [Anvil](^minecraft:anvil) with path pointing to that image. Its custom name can be 3 times longer than that of other items.


The Interplanar Projector is consumed when image is loaded.

;;;;;

&spotlight(exposure:broken_interplanar_projector)
If loading fails, Projector will break and show an error code.


Even if failed, frame would be exposed as a regular photo with inverted color effect.


Broken Interplanar Projector can be repaired by crafting it with an [Eye of Ender](^minecraft:ender_eye).

;;;;;

&title(Image Format)
Most popular image formats are supported: png, jpg, bmp, gif (will not be animated), and some others.

Transparency in images is supported, but only if the pixel is fully transparent.

;;;;;

&title(Image Paths)
File paths should be an absolute path to the file: `D:/Images/cat.png`.

Extension is optional, but might be needed if a folder contains another file with the same name.


URLs should begin with `https://` or `http://`.

;;;;;

&title(Projector Modes)
Mode is changed by pressing <keybind;key.use> the item.

- Clean - image will not be dithered; colors will be mapped to nearest color in a palette.
- Dithered - image will be dithered as usual.
