```json
{
  "title": "Ancient City",
  "icon_sprite": "minecraft:icon/ancient_city",
  "category": "minecraft:structures"
}
```

An **ancient city** is a palatial [structure](^minecraft:structures) found in [deep dark biomes](^minecraft:deep_dark) at layer -51, harboring chests containing some items that cannot be found anywhere else. It is also the largest structure in the game.

;;;;;

&title(Appearance)
![Ancient City](minecraft:textures/gui/image/ancient_city.png,fit)

;;;;;

&title(Generation)
Ancient cities cannot generate overlapping each other, however they can generate directly adjacent to each other.


Because they can only generate in the [deep dark](^minecraft:deep_dark), they will often be found under [mountains](^minecraft:tag/is_mountain) and are more likely to generate in places with low erosion.

;;;;;

&title(Environment Aesthetics)
An ancient city features a very large palace with a footprint of around 220 blocks on each horizontal axis, stretching throughout a [deep dark](^minecraft:deep_dark) biome. The floor of the city always generates at the Y level of -51.

;;;;;

&title(Palace)
The palace is made up of long corridors with 2-block-deep layers of gray wool on the floor, and some rugs made of blue, light blue and cyan wool or carpet floors to prevent vibrations, as well as some smaller ruins off to the side of the main corridors, which contain either one or two loot chests.

;;;;;

&title(Statues)
The city has statues and the center features a frame resembling a [warden](^minecraft:warden)'s head, where there are [reinforced deepslate](^minecraft:reinforced_deepslate) blocks, which is an unobtainable material in Survival mode.

;;;;;

&title(Blocks)
Other unique blocks such as soul lanterns and candles as well as different forms of deepslate and [sculk](^minecraft:sculk) can be found here. [Sculk shriekers](^minecraft:sculk_shrieker) generate much more frequently in ancient cities than in the normal [deep dark](^minecraft:deep_dark) biome. The city generates always at the same places in chunks. 

;;;;;

&title(City Center)
Some structures resemble elements of the game. The city center bears a resemblance to early iterations of the [warden](^minecraft:warden)'s design, and other structures resemble pillager outposts, woodland mansion rooms, and mineshafts.

;;;;;

&title(Redstone Circuits)
Underneath the frame at the city center lies a series of hidden basements with naturally generating redstone circuitry.

;;;;;

&title(Loot)
The loot in the chests includes several useful items for exploring the ancient city, such as snowballs and the [Swift Sneak enchantment](^minecraft:swift_sneak), as well as items that can't be found anywhere else, such as [echo shards](^minecraft:echo_shard) and two exclusive [armor trims](^minecraft:tag/trim_templates).
