```json
{
  "title": "Bamboo",
  "icon": "minecraft:bamboo",
  "categories": [
    "minecraft:blocks",
    "minecraft:fertilizable",
    "minecraft:group/natural_blocks"
  ],
  "associated_items": [
    "minecraft:bamboo"
  ]
}
```

&spotlight(minecraft:bamboo)
**Bamboo** is a versatile, fast-growing plant found primarily in jungles, used for [crafting](^minecraft:crafting), [smelting](^minecraft:smelting), and [breeding](^minecraft:breeding) pandas.


A **bamboo shoot** is the initial non-solid sapling form of planted bamboo.

;;;;;

![Bamboo Stages](minecraft:textures/gui/image/bamboo_stages.png,fit)

The different stages of bamboo growth.

;;;;;

&title(Breaking)
Bamboo stalks can be [mined](^minecraft:breaking) with any [tool](^minecraft:tool), but an [axe](^minecraft:tag/axes) is quicker than other tools. Using a [sword](^minecraft:tag/swords) of any type breaks bamboo stalks and bamboo shoots instantly, even with Mining Fatigue. Flowing water also breaks bamboo shoots, but not mature bamboo stalks.

;;;;;

&title(Natural Generation)
Bamboo generates in widely scattered single shoots within jungle [biomes](^minecraft:biomes). Bamboo generates much more densely in the bamboo variants of jungles, covering large areas of the landscape. Bamboo does not generate in sparse jungles.

;;;;;

&title(Mob Loot)
<|mob-loot@minecraft:knowlogy_components|mob=minecraft:panda,chance=100%,item=minecraft:bamboo,quantity=|>

A panda drops 1 bamboo when killed. Looting does not affect the drop rate.

;;;;;

&title(Generated Loot)
<|generated-loot@minecraft:knowlogy_components|structure=minecraft.jungle_pyramid,container=minecraft:chest,chance=51%,item=minecraft:bamboo,quantity=1-3|>
<|generated-loot@minecraft:knowlogy_components|structure=minecraft.shipwreck,container=minecraft:chest,chance=14.4%,item=minecraft:bamboo,quantity=1-3|>

Bamboo have a chance to be found inside [chests](^minecraft:chest) generated in [Jungle Pyramids](^minecraft:jungle_pyramid) and inside supply [chests](^minecraft:chest) generated in [Shipwrecks](^minecraft:shipwreck).

;;;;;

&title(Usage)
When broken, any bamboo block placed or grown above it is also broken. A bamboo block drops itself as an item if a piston pushes it or moves a block into its space. When bamboo is first placed as a shoot it’s not solid and can be destroyed by water flowing into it. After growing at least one block taller it becomes a solid stalk and cannot be destroyed by water.

;;;;;

&title(Farming)
Bamboo can be planted on moss blocks, grass blocks, dirt, coarse dirt, rooted dirt, gravel, mycelium, podzol, sand, red sand, suspicious sand, suspicious gravel, mud, muddy mangrove roots, bamboo shoot, or on itself. At default random tick speed (3), each plant grows on average every 4096 game ticks (204.8 seconds). 

;;;;;

&title(Fertilizer)
When [bone meal](^minecraft:bone_meal) is used on it, it grows by 1–2 blocks. Bamboo can grow up to 12–16 blocks tall. The top of a bamboo plant requires a light level of 9 or above to grow.

;;;;;

&title(Pandas)
Bamboo items are eaten by pandas and can be used to speed up the growth of baby pandas. Bamboo can also be used to [breed](^minecraft:breeding) pandas when at least 1 bamboo block (not a bamboo shoot) is within 5 blocks of the pandas, making the panda the only animal in the game to have extra breeding requirements. At this point, the player can feed them bamboo and they mate to have a baby.

;;;;;

&title(Fuel)
Bamboo can be used as fuel for [smelting](^minecraft:smelting). Each bamboo item smelts 0.25 items.


Bamboo can be [crafted](^minecraft:crafting) into other items to increase its fuel efficiency. 

;;;;;

&title(Flower Pots)
Bamboo can be placed in a flower pot, where it retains the design it has in its item form.

;;;;;

&title(Crafting Ingredient)
<recipe;bamboo_block>
<recipe;scaffolding>

;;;;;

&title(Crafting Ingredient)
<recipe;stick_from_bamboo_item>
