/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.recipe;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.amendments.common.recipe.CauldronRecipeInput;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class RecipeUtils {
    public static Pair<ItemStack, Float> craftWithFluidAndDye(Level level, SoftFluidStack fluid, ItemStack toRecolor) {
        Pair<ItemStack, Float> c = RecipeUtils.craftWithFluid(level, fluid, toRecolor, true);
        if (c != null) {
            return c;
        }
        DyeItem dyeItem = DyeItem.byColor((DyeColor)DyeBottleItem.getClosestDye(fluid));
        ItemStack recolored = RecipeUtils.simulateCrafting(level, toRecolor, dyeItem.getDefaultInstance(), false);
        if (recolored != null) {
            return Pair.of((Object)recolored, (Object)Float.valueOf(1.0f));
        }
        return null;
    }

    public static Pair<ItemStack, Float> craftWithFluid(Level level, SoftFluidStack fluidStack, ItemStack playerItem, boolean try9x9) {
        if (playerItem.isEmpty()) {
            return null;
        }
        SoftFluid sf = fluidStack.fluid();
        for (FluidContainerList.Category category : sf.getContainerList().getCategories()) {
            int actualCapacity;
            ItemStack crafted8;
            Pair p;
            int capacity = category.getCapacity();
            if (capacity > fluidStack.getCount() || (p = fluidStack.toItem(category.getEmptyContainer().getDefaultInstance(), true)) == null) continue;
            ItemStack crafted = RecipeUtils.simulateCrafting(level, (ItemStack)p.getFirst(), playerItem, false);
            if (crafted != null) {
                return Pair.of((Object)crafted, (Object)Float.valueOf(capacity));
            }
            if (!try9x9 || (crafted8 = RecipeUtils.simulateCrafting(level, (ItemStack)p.getFirst(), playerItem, true)) == null || (actualCapacity = 8 / crafted8.getCount()) <= 0) continue;
            return Pair.of((Object)crafted8, (Object)Float.valueOf(actualCapacity));
        }
        return null;
    }

    public static ItemStack simulateCrafting(Level level, ItemStack dye, ItemStack playerItem, boolean surround) {
        CraftingInput container = surround ? CauldronRecipeInput.surround(dye.copy(), playerItem.copy()) : CauldronRecipeInput.of(dye.copy(), playerItem.copy());
        List recipes = level.getRecipeManager().getRecipesFor(RecipeType.CRAFTING, (RecipeInput)container, level);
        for (RecipeHolder r : recipes) {
            CraftingRecipe recipe = (CraftingRecipe)r.value();
            ItemStack recolored = recipe.assemble((RecipeInput)container, (HolderLookup.Provider)level.registryAccess());
            if (recolored.isEmpty() || playerItem.equals(recolored)) continue;
            NonNullList remainingItems = recipe.getRemainingItems((RecipeInput)container);
            remainingItems.remove((Object)Items.GLASS_BOTTLE.getDefaultInstance());
            if (!remainingItems.stream().noneMatch(i -> !i.isEmpty() && !i.is(Items.GLASS_BOTTLE))) continue;
            return recolored;
        }
        return null;
    }
}

