/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.entity;

import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedFallingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FallingLanternEntity
extends ImprovedFallingBlockEntity {
    public FallingLanternEntity(EntityType<FallingLanternEntity> type, Level level) {
        super(type, level);
    }

    public FallingLanternEntity(Level level) {
        super(ModRegistry.FALLING_LANTERN.get(), level);
    }

    public FallingLanternEntity(Level level, BlockPos pos, BlockState blockState, double yOffset) {
        super(ModRegistry.FALLING_LANTERN.get(), level, pos, blockState, false);
        this.yo = (double)pos.getY() + yOffset;
    }

    public static FallingBlockEntity fall(Level level, BlockPos pos, BlockState state, double yOffset) {
        FallingLanternEntity entity = new FallingLanternEntity(level, pos, state, yOffset);
        level.setBlock(pos, state.getFluidState().createLegacyBlock(), 3);
        level.addFreshEntity((Entity)entity);
        return entity;
    }

    public boolean causeFallDamage(float height, float amount, DamageSource source) {
        boolean r = super.causeFallDamage(height, amount, source);
        if (CommonConfigs.FALLING_LANTERNS.get().hasFire() && this.getDeltaMovement().lengthSqr() > 0.16000000000000003) {
            BlockState state = this.getBlockState();
            BlockPos pos = BlockPos.containing((double)this.getX(), (double)(this.getY() + 0.25), (double)this.getZ());
            Level level = this.level();
            level.levelEvent(null, 2001, pos, Block.getId((BlockState)state));
            if (state.getLightEmission() != 0) {
                if (CompatHandler.SUPPLEMENTARIES && level instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    SuppCompat.createMiniExplosion(l, pos, true);
                } else if (level.getBlockState(pos).isAir() && BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)pos, (Direction)Direction.DOWN)) {
                    level.setBlockAndUpdate(pos, BaseFireBlock.getState((BlockGetter)level, (BlockPos)pos));
                }
            } else {
                this.spawnAtLocation((ItemLike)state.getBlock());
            }
            this.setCancelDrop(true);
            this.discard();
        }
        return r;
    }

    public static boolean canSurviveCeilingAndMaybeFall(BlockState state, BlockPos pos, LevelReader worldIn) {
        if (!Amendments.isSupportingCeiling(pos.above(), worldIn) && worldIn instanceof Level) {
            Level l = (Level)worldIn;
            if (CommonConfigs.FALLING_LANTERNS.get().isOn() && l.getBlockState(pos).is(state.getBlock())) {
                return FallingLanternEntity.createFallingLantern(state, pos, l);
            }
            return false;
        }
        return true;
    }

    public static boolean createFallingLantern(BlockState state, BlockPos pos, Level level) {
        if (FallingBlock.isFree((BlockState)level.getBlockState(pos.below())) && pos.getY() >= level.getMinBuildHeight() && state.hasProperty((Property)LanternBlock.HANGING)) {
            double maxY = state.getShape((BlockGetter)level, (BlockPos)pos).bounds().maxY;
            state = (BlockState)state.setValue((Property)LanternBlock.HANGING, (Comparable)Boolean.valueOf(false));
            double yOffset = maxY - state.getShape((BlockGetter)level, (BlockPos)pos).bounds().maxY;
            FallingLanternEntity.fall(level, pos, state, yOffset);
            return true;
        }
        return false;
    }

    public static enum FallMode {
        ON,
        OFF,
        NO_FIRE;


        public boolean hasFire() {
            return this != NO_FIRE;
        }

        public boolean isOn() {
            return this != OFF;
        }
    }
}

