/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.mehvahdjukaar.dummmmmmy.Dummmmmmy;
import net.mehvahdjukaar.dummmmmmy.configs.ClientConfigs;
import net.mehvahdjukaar.dummmmmmy.configs.CritMode;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class DamageNumberParticle
extends Particle {
    private static final List<Float> POSITIONS = new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(-0.25f), Float.valueOf(0.12f), Float.valueOf(-0.12f), Float.valueOf(0.25f)));
    private final Font fontRenderer;
    private final Component text;
    private final int color;
    private final int darkColor;
    private float fadeout;
    private float prevFadeout;
    private float visualDY;
    private float prevVisualDY;
    private float visualDX;
    private float prevVisualDX;

    public DamageNumberParticle(ClientLevel clientLevel, double x, double y, double z, double amount, double dColor, double dz) {
        super(clientLevel, x, y, z);
        this.fontRenderer = Minecraft.getInstance().font;
        this.fadeout = -1.0f;
        this.prevFadeout = -1.0f;
        this.visualDY = 0.0f;
        this.prevVisualDY = 0.0f;
        this.visualDX = 0.0f;
        this.prevVisualDX = 0.0f;
        this.lifetime = 35;
        this.color = amount < 0.0 ? -16711936 : (int)dColor;
        this.darkColor = FastColor.ARGB32.color((int)255, (int)((int)(this.rCol * 0.25f)), (int)((int)(this.rCol * 0.25f)), (int)((int)((double)this.rCol * 0.25)));
        double number = Math.abs(ClientConfigs.SHOW_HEARTHS.get() != false ? amount / 2.0 : amount);
        this.yd = 1.0;
        int index = CritMode.extractIntegerPart(dz);
        float critMult = CritMode.extractFloatPart(dz);
        this.text = critMult == 0.0f ? Component.literal((String)((amount < 0.0 ? "+" : "") + Dummmmmmy.DF2.format(number))) : Component.translatable((String)"message.dummmmmmy.crit", (Object[])new Object[]{Dummmmmmy.DF1.format(number), Dummmmmmy.DF1.format(critMult)});
        this.xd = POSITIONS.get(index % POSITIONS.size()).floatValue();
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        Vec3 cameraPos = camera.getPosition();
        float particleX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPos.x());
        float particleY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPos.y());
        float particleZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPos.z());
        int light = ClientConfigs.LIT_UP_PARTICLES.get() != false ? 0xF000F0 : this.getLightColor(partialTicks);
        PoseStack poseStack = new PoseStack();
        poseStack.pushPose();
        poseStack.translate(particleX, particleY, particleZ);
        double distanceFromCam = new Vec3((double)particleX, (double)particleY, (double)particleZ).length();
        double inc = Mth.clamp((double)(distanceFromCam / 32.0), (double)0.0, (double)5.0);
        poseStack.translate(0.0, (1.0 + inc / 4.0) * (double)Mth.lerp((float)partialTicks, (float)this.prevVisualDY, (float)this.visualDY), 0.0);
        float fadeout = Mth.lerp((float)partialTicks, (float)this.prevFadeout, (float)this.fadeout);
        float defScale = 0.006f;
        float scale = (float)((double)defScale * distanceFromCam);
        poseStack.mulPose(camera.rotation());
        poseStack.translate((1.0 + inc) * (double)Mth.lerp((float)partialTicks, (float)this.prevVisualDX, (float)this.visualDX), 0.0, 0.0);
        poseStack.scale(scale, -scale, -scale);
        poseStack.translate(0.0, 4.0 * (double)(1.0f - fadeout), 0.0);
        poseStack.scale(fadeout, fadeout, fadeout);
        poseStack.translate(0.0, -distanceFromCam / 10.0, 0.0);
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        float x1 = 0.5f - (float)this.fontRenderer.width((FormattedText)this.text) / 2.0f;
        this.fontRenderer.drawInBatch(this.text, x1, 0.0f, this.color, false, poseStack.last().pose(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, light);
        poseStack.translate(1.0, 1.0, 0.03);
        this.fontRenderer.drawInBatch(this.text, x1, 0.0f, this.darkColor, false, poseStack.last().pose(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, light);
        buffer.endBatch();
        poseStack.popPose();
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            float length = 6.0f;
            this.prevFadeout = this.fadeout;
            this.fadeout = (float)this.age > (float)this.lifetime - length ? ((float)this.lifetime - (float)this.age) / length : 1.0f;
            this.prevVisualDY = this.visualDY;
            this.visualDY = (float)((double)this.visualDY + this.yd);
            this.prevVisualDX = this.visualDX;
            this.visualDX = (float)((double)this.visualDX + this.xd);
            if (Math.sqrt(Mth.square((double)((double)this.visualDX * 1.5)) + (double)Mth.square((float)(this.visualDY - 1.0f))) < 0.8999999999999999) {
                this.yd /= 2.0;
            } else {
                this.yd = 0.0;
                this.xd = 0.0;
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet spriteSet) {
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new DamageNumberParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

