/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.bytecodecs;

import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.ExtraByteCodecs;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class StreamCodecByteCodec {
    private static <B extends ByteBuf, T> ByteCodec<T> of(StreamCodec<B, T> codec, Function<ByteBuf, B> mapper) {
        return ByteCodec.passthrough((buf, value) -> codec.encode((Object)((ByteBuf)mapper.apply((ByteBuf)buf)), value), buffer -> codec.decode((Object)((ByteBuf)mapper.apply((ByteBuf)buffer))));
    }

    private static <B extends ByteBuf, T> StreamCodec<B, T> to(ByteCodec<T> codec, Function<B, ByteBuf> mapper) {
        return StreamCodec.of((buf, value) -> codec.encode(value, (ByteBuf)mapper.apply(buf)), buf -> codec.decode((ByteBuf)mapper.apply(buf)));
    }

    public static <T> ByteCodec<T> of(StreamCodec<ByteBuf, T> codec) {
        return StreamCodecByteCodec.of(codec, Function.identity());
    }

    public static <T> StreamCodec<ByteBuf, T> to(ByteCodec<T> codec) {
        return StreamCodecByteCodec.to(codec, Function.identity());
    }

    public static <T> ByteCodec<T> ofFriendly(StreamCodec<FriendlyByteBuf, T> codec) {
        return StreamCodecByteCodec.of(codec, ExtraByteCodecs::toFriendly);
    }

    public static <T> StreamCodec<FriendlyByteBuf, T> toFriendly(ByteCodec<T> codec) {
        return StreamCodecByteCodec.to(codec, ExtraByteCodecs::toFriendly);
    }

    public static <T> ByteCodec<T> ofRegistry(StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        return StreamCodecByteCodec.of(codec, ExtraByteCodecs::toRegistry);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> toRegistry(ByteCodec<T> codec) {
        return StreamCodecByteCodec.to(codec, ExtraByteCodecs::toRegistry);
    }
}

