/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.create_d2d.register;

import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.lopyluna.create_d2d.DesiresCreate;
import dev.lopyluna.create_d2d.register.DesiresSoundTypes;
import dev.lopyluna.create_d2d.register.DesiresTags;
import dev.lopyluna.create_d2d.register.helpers.wood_types.BlockPattern;
import dev.lopyluna.create_d2d.register.helpers.wood_types.VariantEntry;
import java.util.function.Function;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MapColor;

public enum DesiresStoneTypes {
    STONE(BlockPattern.VANILLA_RANGE, r -> () -> Blocks.STONE),
    PACKED_MUD(BlockPattern.VANILLA_RANGE, r -> () -> Blocks.PACKED_MUD),
    AMETHYST_BLOCK(BlockPattern.VANILLA_RANGE, r -> () -> Blocks.AMETHYST_BLOCK),
    NETHERRACK(BlockPattern.VANILLA_RANGE, r -> () -> Blocks.NETHERRACK),
    BASALT(BlockPattern.VANILLA_RANGE, r -> () -> Blocks.BASALT),
    BLACKSTONE(BlockPattern.VANILLA_RANGE, r -> () -> Blocks.BLACKSTONE),
    WEATHERED_LIMESTONE(BlockPattern.STANDARD_RANGE, r -> r.paletteStoneBlock("weathered_limestone", () -> Blocks.SANDSTONE, true, false).properties(p -> p.mapColor(MapColor.COLOR_LIGHT_GRAY)).register()),
    GABBRO(BlockPattern.STANDARD_RANGE, r -> r.paletteStoneBlock("gabbro", () -> Blocks.POLISHED_DEEPSLATE, true, false).properties(p -> p.destroyTime(1.25f).mapColor(MapColor.TERRACOTTA_LIGHT_GRAY)).register()),
    DOLOMITE(BlockPattern.STANDARD_RANGE, r -> r.paletteStoneBlock("dolomite", () -> Blocks.TUFF, true, false).properties(p -> p.destroyTime(1.25f).mapColor(MapColor.TERRACOTTA_WHITE)).register()),
    BRECCIA(BlockPattern.STANDARD_RANGE, r -> r.paletteStoneBlock("breccia", () -> Blocks.TUFF, true, true).properties(p -> p.destroyTime(1.25f).sound(DesiresSoundTypes.CRACKLE_STONE).mapColor(MapColor.COLOR_ORANGE)).register());

    private final Function<CreateRegistrate, NonNullSupplier<Block>> factory;
    private VariantEntry variants;
    public NonNullSupplier<Block> baseBlock;
    public final BlockPattern[] variantTypes;
    public TagKey<Item> materialTag;

    private DesiresStoneTypes(BlockPattern[] variantTypes, Function<CreateRegistrate, NonNullSupplier<Block>> factory) {
        this.factory = factory;
        this.variantTypes = variantTypes;
    }

    public NonNullSupplier<Block> getBaseBlock() {
        return this.baseBlock;
    }

    public VariantEntry getVariants() {
        return this.variants;
    }

    public static void register(CreateRegistrate registrate) {
        for (DesiresStoneTypes paletteStoneVariants : DesiresStoneTypes.values()) {
            paletteStoneVariants.baseBlock = paletteStoneVariants.factory.apply(registrate);
            String id = Lang.asId((String)paletteStoneVariants.name());
            paletteStoneVariants.materialTag = DesiresTags.optionalTag(BuiltInRegistries.ITEM, DesiresCreate.loc("stone_types/" + id));
            paletteStoneVariants.variants = new VariantEntry(id, paletteStoneVariants);
        }
    }
}

