/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.create_d2d.content.blocks.stirling_engine.flywheel;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.create_d2d.content.blocks.stirling_engine.flywheel.PoweredFlywheelBE;
import dev.lopyluna.create_d2d.content.blocks.stirling_engine.flywheel.PoweredFlywheelBlock;
import dev.lopyluna.create_d2d.register.client.DesiresPartialModels;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PoweredFlywheelRenderer
extends KineticBlockEntityRenderer<PoweredFlywheelBE> {
    public PoweredFlywheelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(PoweredFlywheelBE be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        BlockState state = be.getBlockState();
        float speed = be.visualSpeed.getValue(partialTicks) * 3.0f / 10.0f;
        float angle = be.angle + speed * partialTicks;
        VertexConsumer vb = buffer.getBuffer(RenderType.solid());
        this.renderFlywheel(be, ms, light, state, angle, vb);
    }

    private void renderFlywheel(PoweredFlywheelBE be, PoseStack ms, int light, BlockState blockState, float angle, VertexConsumer vb) {
        SuperByteBuffer wheel = CachedBuffers.partialFacing((PartialModel)DesiresPartialModels.FLYWHEEL, (BlockState)blockState, (Direction)((Direction)blockState.getValue((Property)PoweredFlywheelBlock.FACING)));
        PoweredFlywheelRenderer.kineticRotationTransform((SuperByteBuffer)wheel, (KineticBlockEntity)be, (Direction.Axis)PoweredFlywheelRenderer.getRotationAxisOf((KineticBlockEntity)be), (float)AngleHelper.rad((double)angle), (int)light);
        wheel.renderInto(ms, vb);
    }

    protected SuperByteBuffer getRotatedModel(PoweredFlywheelBE be, BlockState state) {
        return CachedBuffers.partialFacing((PartialModel)DesiresPartialModels.FLYWHEEL, (BlockState)state, (Direction)((Direction)state.getValue((Property)PoweredFlywheelBlock.FACING)).getOpposite());
    }

    protected BlockState getRenderedBlockState(PoweredFlywheelBE be) {
        return PoweredFlywheelRenderer.shaft((Direction.Axis)PoweredFlywheelRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }
}

