/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.create_d2d.content.blocks.stirling_engine;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.lopyluna.create_d2d.content.blocks.stirling_engine.StirlingEngineBlock;
import dev.lopyluna.create_d2d.content.blocks.stirling_engine.StirlingEngineValueBox;
import dev.lopyluna.create_d2d.content.blocks.stirling_engine.flywheel.PoweredFlywheelBE;
import dev.lopyluna.create_d2d.mixins.FurnaceBEAccessor;
import dev.lopyluna.create_d2d.register.DesiresBlocks;
import dev.lopyluna.create_d2d.register.DesiresTags;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class StirlingEngineBE
extends SmartBlockEntity
implements IHaveGoggleInformation {
    protected ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    public WeakReference<PoweredFlywheelBE> target;
    public WeakReference<AbstractFurnaceBlockEntity> source = new WeakReference<Object>(null);
    public float prevAngle = 0.0f;
    public int delayedTimer = 0;

    public StirlingEngineBE(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.target = new WeakReference<Object>(null);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)CreateLang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new StirlingEngineValueBox());
        this.movementDirection.onlyActiveWhen(() -> {
            PoweredFlywheelBE shaft = this.getFlywheel();
            return shaft == null || !shaft.hasSource();
        });
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.STEAM_ENGINE});
    }

    private void onDirectionChanged() {
    }

    public void tick() {
        int conveyedSpeedLevel;
        float efficiency;
        float smelting;
        BlockState furnaceState;
        super.tick();
        if (this.level == null) {
            return;
        }
        AbstractFurnaceBlockEntity furnace = this.getFurnace();
        PoweredFlywheelBE flywheel = this.getFlywheel();
        if (furnace == null || flywheel == null) {
            if (this.level.isClientSide()) {
                return;
            }
            if (flywheel == null) {
                return;
            }
            if (!flywheel.getBlockPos().subtract((Vec3i)this.worldPosition).equals((Object)flywheel.enginePos)) {
                return;
            }
            if (flywheel.engineEfficiency == 0.0f) {
                return;
            }
            Direction facing = StirlingEngineBlock.getFacing(this.getBlockState());
            if (this.level.isLoaded(this.worldPosition.relative(facing.getOpposite()))) {
                flywheel.update(facing.getOpposite(), this.worldPosition, 0, 0.0f);
            }
            return;
        }
        BlockState shaftState = flywheel.getBlockState();
        Direction.Axis targetAxis = Direction.Axis.X;
        Block block = shaftState.getBlock();
        if (block instanceof IRotate) {
            IRotate ir = (IRotate)block;
            targetAxis = ir.getRotationAxis(shaftState);
        }
        boolean verticalTarget = targetAxis == Direction.Axis.Y;
        BlockState blockState = this.getBlockState();
        if (!DesiresBlocks.STIRLING_ENGINE.has(blockState)) {
            return;
        }
        Direction facing = StirlingEngineBlock.getFacing(blockState);
        if (facing.getAxis() == Direction.Axis.Y) {
            facing = (Direction)blockState.getValue((Property)StirlingEngineBlock.FACING);
        }
        float multiplier = (furnaceState = furnace.getBlockState()).is(DesiresTags.BlockTags.SUPER_STRONG_FURNACE.tag) ? 1.0f : (furnaceState.is(DesiresTags.BlockTags.STRONG_FURNACE.tag) ? 0.75f : (furnaceState.is(DesiresTags.BlockTags.WEAK_FURNACE.tag) ? 0.25f : 0.5f));
        FurnaceBEAccessor access = (FurnaceBEAccessor)furnace;
        float f = smelting = access.getCookingProgress$D2D() > 0 && access.getCookingTotalTime$D2D() > 0 ? 1.0f : 0.0f;
        if (smelting > 0.0f) {
            this.award(AllAdvancements.STEAM_ENGINE);
        }
        if (smelting > 0.0f && this.delayedTimer < 6) {
            ++this.delayedTimer;
        } else if (this.delayedTimer > 0) {
            --this.delayedTimer;
        }
        float f2 = efficiency = this.delayedTimer > 1 ? multiplier : 0.0f;
        int n = efficiency == 0.0f ? 1 : (conveyedSpeedLevel = verticalTarget ? 1 : (int)GeneratingKineticBlockEntity.convertToDirection((float)1.0f, (Direction)facing));
        if (targetAxis == Direction.Axis.Z) {
            conveyedSpeedLevel *= -1;
        }
        if (this.movementDirection.get() == WindmillBearingBlockEntity.RotationDirection.COUNTER_CLOCKWISE) {
            conveyedSpeedLevel *= -1;
        }
        float shaftSpeed = flywheel.getTheoreticalSpeed();
        if (flywheel.hasSource() && shaftSpeed != 0.0f && conveyedSpeedLevel != 0 && shaftSpeed > 0.0f != conveyedSpeedLevel > 0) {
            this.movementDirection.setValue(1 - ((WindmillBearingBlockEntity.RotationDirection)this.movementDirection.get()).ordinal());
            conveyedSpeedLevel *= -1;
        }
        flywheel.update(facing.getOpposite(), this.worldPosition, conveyedSpeedLevel, efficiency);
        if (!this.level.isClientSide) {
            return;
        }
        CatnipServices.PLATFORM.executeOnClientOnly(() -> this::spawnParticles);
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        tag.putInt("DelayedTimer", this.delayedTimer);
        super.write(tag, registries, clientPacket);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.delayedTimer = tag.getInt("DelayedTimer");
    }

    public void remove() {
        PoweredFlywheelBE flywheel = this.getFlywheel();
        if (flywheel != null) {
            flywheel.remove(this.worldPosition);
        }
        super.remove();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(2.0);
    }

    public PoweredFlywheelBE getFlywheel() {
        PoweredFlywheelBE flywheel = (PoweredFlywheelBE)((Object)this.target.get());
        if (flywheel == null || flywheel.isRemoved() || !flywheel.canBePoweredBy(this.worldPosition)) {
            PoweredFlywheelBE ps;
            BlockEntity blockEntity;
            if (flywheel != null) {
                this.target = new WeakReference<Object>(null);
            }
            Direction facing = StirlingEngineBlock.getFacing(this.getBlockState());
            if (this.level != null && (blockEntity = this.level.getBlockEntity(this.worldPosition.relative(facing, 2))) instanceof PoweredFlywheelBE && (ps = (PoweredFlywheelBE)blockEntity).canBePoweredBy(this.worldPosition)) {
                flywheel = ps;
                this.target = new WeakReference<PoweredFlywheelBE>(flywheel);
            }
        }
        return flywheel;
    }

    public AbstractFurnaceBlockEntity getFurnace() {
        AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)this.source.get();
        if (furnace == null || furnace.isRemoved()) {
            BlockEntity blockEntity;
            if (furnace != null) {
                this.source = new WeakReference<Object>(null);
            }
            Direction facing = StirlingEngineBlock.getFacing(this.getBlockState());
            if (this.level != null && (blockEntity = this.level.getBlockEntity(this.worldPosition.relative(facing.getOpposite()))) instanceof AbstractFurnaceBlockEntity) {
                AbstractFurnaceBlockEntity furnaceBe;
                furnace = furnaceBe = (AbstractFurnaceBlockEntity)blockEntity;
                this.source = new WeakReference<AbstractFurnaceBlockEntity>(furnace);
            }
        }
        return furnace;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
        Float targetAngle = this.getTargetAngle();
        PoweredFlywheelBE ste = (PoweredFlywheelBE)((Object)this.target.get());
        if (ste != null && ste.isPoweredBy(this.worldPosition) && targetAngle != null) {
            float angle;
            angle += (angle = AngleHelper.deg((double)targetAngle.floatValue())) < 0.0f ? -105.0f : 285.0f;
            angle %= 360.0f;
            PoweredFlywheelBE flywheel = this.getFlywheel();
            if (flywheel != null && flywheel.getSpeed() != 0.0f) {
                AbstractFurnaceBlockEntity sourceBE;
                if ((!(angle >= 0.0f) || this.prevAngle > 180.0f && angle < 180.0f) && (!(angle < 0.0f) || this.prevAngle < -180.0f && angle > -180.0f) && (sourceBE = (AbstractFurnaceBlockEntity)this.source.get()) != null) {
                    float volume = 1.5f;
                    assert (this.level != null);
                    float pitch = 0.28f + this.level.random.nextFloat() * 0.1f;
                    this.level.playLocalSound((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, volume, pitch, false);
                    AllSoundEvents.STEAM.playAt(this.level, (Vec3i)this.worldPosition, volume / 16.0f, 0.25f, false);
                }
                this.prevAngle = angle;
            }
        }
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Float getTargetAngle() {
        BlockState blockState = this.getBlockState();
        if (DesiresBlocks.STIRLING_ENGINE.has(blockState)) {
            Direction facing = StirlingEngineBlock.getFacing(blockState);
            PoweredFlywheelBE flywheel = this.getFlywheel();
            Direction.Axis facingAxis = facing.getAxis();
            if (flywheel != null) {
                Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)flywheel);
                float angle = KineticBlockEntityRenderer.getAngleForBe((KineticBlockEntity)flywheel, (BlockPos)flywheel.getBlockPos(), (Direction.Axis)axis);
                if (axis != facingAxis) {
                    if (axis.isHorizontal() && facingAxis == Direction.Axis.X ^ facing.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                        angle *= -1.0f;
                    }
                    if (axis == Direction.Axis.X && facing == Direction.DOWN) {
                        angle *= -1.0f;
                    }
                    return Float.valueOf(angle);
                }
            }
        }
        return null;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        PoweredFlywheelBE flywheel = this.getFlywheel();
        return flywheel != null && flywheel.addToEngineTooltip(tooltip, isPlayerSneaking);
    }
}

