/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.create_d2d.content.blocks.hydraulic_press;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.create_d2d.content.blocks.hydraulic_press.HydraulicPressBE;
import dev.lopyluna.create_d2d.content.blocks.hydraulic_press.HydraulicPressingBehavior;
import dev.lopyluna.create_d2d.register.client.DesiresPartialModels;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class HydraulicPressRenderer
extends KineticBlockEntityRenderer<HydraulicPressBE> {
    public HydraulicPressRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(HydraulicPressBE be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        this.renderFluid(be, partialTicks, ms, buffer, light);
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        BlockState blockState = be.getBlockState();
        HydraulicPressingBehavior pressingBehaviour = be.pressingBehaviour;
        ms.pushPose();
        float renderedHeadOffset = pressingBehaviour.getRenderedHeadOffset(partialTicks) * pressingBehaviour.mode.headOffset;
        SuperByteBuffer headRender = CachedBuffers.partialFacing((PartialModel)DesiresPartialModels.HYDRAULIC_HEAD, (BlockState)blockState, (Direction)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        ((SuperByteBuffer)headRender.translate(0.0f, -renderedHeadOffset, 0.0f)).light(light).renderInto(ms, buffer.getBuffer(RenderType.solid()));
        ms.popPose();
    }

    protected void renderFluid(HydraulicPressBE be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
        SmartFluidTankBehaviour tank = be.tank;
        SmartFluidTankBehaviour.TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        float level = primaryTank.getFluidLevel().getValue(partialTicks);
        if (!fluidStack.isEmpty() && level != 0.0f && !(level < 0.00390625f)) {
            float clampedLevel = Mth.clamp((float)(level * 0.5f), (float)0.0f, (float)0.5f);
            boolean top = fluidStack.getFluid().getFluidType().isLighterThanAir();
            float yMin = 0.75f - clampedLevel;
            float yMax = yMin + clampedLevel;
            if (top) {
                yMin += 0.5f - clampedLevel;
                yMax += 0.5f - clampedLevel;
            }
            ms.pushPose();
            ms.translate(0.0f, clampedLevel - 0.5f, 0.0f);
            FluidRenderer.renderFluidBox((Fluid)fluidStack.getFluid(), (long)fluidStack.getAmount(), (float)0.0703125f, (float)yMin, (float)0.0703125f, (float)0.9296875f, (float)yMax, (float)0.9296875f, (MultiBufferSource)buffer, (PoseStack)ms, (int)light, (boolean)false, (boolean)true, (DataComponentPatch)fluidStack.getComponentsPatch());
            ms.popPose();
        }
    }

    public boolean shouldRenderOffScreen(HydraulicPressBE be) {
        return true;
    }

    protected BlockState getRenderedBlockState(HydraulicPressBE be) {
        return HydraulicPressRenderer.shaft((Direction.Axis)HydraulicPressRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }
}

