/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.create_d2d.client.layers;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DnDesireCosmeticLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final String CAPE_URL = "https://github.com/LopyLuna/Obelisb/blob/1.21/dndesire_one_mil_cape.png?raw=true";
    private static ResourceLocation dynamicCapeTexture;
    public String[] uuidList;
    private final ElytraModel<AbstractClientPlayer> elytraModel;
    public static List<String> DISABLED_COSMETICS;

    public DnDesireCosmeticLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> pRenderer, EntityModelSet pModelSet, String[] uuidList) {
        super(pRenderer);
        this.uuidList = uuidList;
        this.elytraModel = new ElytraModel(pModelSet.bakeLayer(ModelLayers.ELYTRA));
    }

    public void render(@NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, @NotNull AbstractClientPlayer pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        String uuid = pLivingEntity.getUUID().toString();
        PlayerModel pModel = (PlayerModel)this.getParentModel();
        if (!DISABLED_COSMETICS.contains(uuid) && (Arrays.stream(this.uuidList).toList().contains(uuid) || "Dev".equals(pLivingEntity.getGameProfile().getName())) && !pLivingEntity.isInvisible()) {
            DnDesireCosmeticLayer.loadCapeTexture();
            if (dynamicCapeTexture != null) {
                ItemStack itemstack = pLivingEntity.getItemBySlot(EquipmentSlot.CHEST);
                if (itemstack.is(Items.ELYTRA)) {
                    pPoseStack.pushPose();
                    pPoseStack.translate(0.0f, 0.0f, 0.145f);
                    pModel.copyPropertiesTo(this.elytraModel);
                    this.elytraModel.setupAnim((LivingEntity)pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
                    VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)pBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)dynamicCapeTexture), (boolean)itemstack.hasFoil());
                    this.elytraModel.renderToBuffer(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY);
                    pPoseStack.pushPose();
                    pPoseStack.translate(0.0f, 0.0f, -0.04f);
                    this.elytraModel.renderToBuffer(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY);
                    pPoseStack.popPose();
                    pPoseStack.popPose();
                } else {
                    pPoseStack.pushPose();
                    pPoseStack.translate(0.0f, 0.0f, 0.145f);
                    double d0 = Mth.lerp((double)pPartialTicks, (double)pLivingEntity.xCloakO, (double)pLivingEntity.xCloak) - Mth.lerp((double)pPartialTicks, (double)pLivingEntity.xo, (double)pLivingEntity.getX());
                    double d1 = Mth.lerp((double)pPartialTicks, (double)pLivingEntity.yCloakO, (double)pLivingEntity.yCloak) - Mth.lerp((double)pPartialTicks, (double)pLivingEntity.yo, (double)pLivingEntity.getY());
                    double d2 = Mth.lerp((double)pPartialTicks, (double)pLivingEntity.zCloakO, (double)pLivingEntity.zCloak) - Mth.lerp((double)pPartialTicks, (double)pLivingEntity.zo, (double)pLivingEntity.getZ());
                    float f = Mth.rotLerp((float)pPartialTicks, (float)pLivingEntity.yBodyRotO, (float)pLivingEntity.yBodyRot);
                    double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
                    double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
                    float f1 = (float)d1 * 10.0f;
                    f1 = Mth.clamp((float)f1, (float)-6.0f, (float)32.0f);
                    float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
                    f2 = Mth.clamp((float)f2, (float)0.0f, (float)150.0f);
                    float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
                    f3 = Mth.clamp((float)f3, (float)-20.0f, (float)20.0f);
                    if (f2 < 0.0f) {
                        f2 = 0.0f;
                    }
                    float f4 = Mth.lerp((float)pPartialTicks, (float)pLivingEntity.oBob, (float)pLivingEntity.bob);
                    f1 += Mth.sin((float)(Mth.lerp((float)pPartialTicks, (float)pLivingEntity.walkDistO, (float)pLivingEntity.walkDist) * 6.0f)) * 32.0f * f4;
                    if (pLivingEntity.isCrouching()) {
                        f1 += 25.0f;
                    }
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(6.0f + f2 / 2.0f + f1));
                    pPoseStack.mulPose(Axis.ZP.rotationDegrees(f3 / 2.0f));
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f - f3 / 2.0f));
                    VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entitySolid((ResourceLocation)dynamicCapeTexture));
                    pModel.renderCloak(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY);
                    pPoseStack.pushPose();
                    pPoseStack.translate(0.0f, 0.0f, -0.04f);
                    pModel.renderCloak(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY);
                    pPoseStack.popPose();
                    pPoseStack.popPose();
                }
            }
        }
    }

    private static void loadCapeTexture() {
        block9: {
            if (dynamicCapeTexture == null) {
                try {
                    HttpURLConnection connection = (HttpURLConnection)new URL(CAPE_URL).openConnection();
                    connection.setRequestMethod("GET");
                    connection.setDoInput(true);
                    connection.connect();
                    if (connection.getResponseCode() != 200) break block9;
                    try (InputStream inputStream = connection.getInputStream();){
                        NativeImage image = NativeImage.read((InputStream)inputStream);
                        dynamicCapeTexture = Minecraft.getInstance().getTextureManager().register("dynamic_cape", new DynamicTexture(image));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    static {
        DISABLED_COSMETICS = new ArrayList<String>();
    }
}

