/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.block.mechanicalfryer;

import com.pyzpre.createbitterballen.block.mechanicalfryer.MechanicalFryerEntity;
import com.pyzpre.createbitterballen.index.BlockEntityRegistry;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.SmartInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.extensions.IBlockExtension;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class MechanicalFryer
extends HorizontalKineticBlock
implements IBE<MechanicalFryerEntity>,
IBlockExtension {
    public MechanicalFryer(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemInHand = player.getItemInHand(handIn);
        if (worldIn.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity be = worldIn.getBlockEntity(pos);
        if (!(be instanceof MechanicalFryerEntity)) {
            return ItemInteractionResult.FAIL;
        }
        MechanicalFryerEntity fryer = (MechanicalFryerEntity)be;
        if (!itemInHand.isEmpty()) {
            ItemStack leftover;
            Item item = itemInHand.getItem();
            if (item instanceof BlockItem) {
                InteractionResult result;
                BlockItem blockItem = (BlockItem)item;
                if (!fryer.canProcess(itemInHand) && (result = blockItem.useOn(new UseOnContext(player, handIn, hit))).consumesAction()) {
                    SoundType soundType = blockItem.getBlock().getSoundType(blockItem.getBlock().defaultBlockState(), (LevelReader)worldIn, pos, (Entity)player);
                    worldIn.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            if (fryer.canProcess(itemInHand) && (leftover = fryer.inputInv.insertItem(0, itemInHand, true)).isEmpty()) {
                fryer.inputInv.insertItem(0, itemInHand.copy(), false);
                player.setItemInHand(handIn, ItemStack.EMPTY);
                fryer.setChanged();
                fryer.sendData();
                return ItemInteractionResult.CONSUME;
            }
        } else {
            int slot;
            boolean emptyOutput = true;
            SmartInventory inv = fryer.outputInv;
            for (slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stackInSlot = inv.getStackInSlot(slot);
                if (stackInSlot.isEmpty()) continue;
                emptyOutput = false;
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stackInSlot);
                inv.setStackInSlot(slot, ItemStack.EMPTY);
            }
            if (emptyOutput) {
                inv = fryer.inputInv;
                for (slot = 0; slot < inv.getSlots(); ++slot) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)inv.getStackInSlot(slot));
                    inv.setStackInSlot(slot, ItemStack.EMPTY);
                }
            }
            fryer.setChanged();
            fryer.sendData();
        }
        return ItemInteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (context instanceof EntityCollisionContext && ((EntityCollisionContext)context).getEntity() instanceof Player) {
            return AllShapes.CASING_14PX.get(Direction.DOWN);
        }
        return AllShapes.MECHANICAL_PROCESSOR_SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return !AllBlocks.BASIN.has(worldIn.getBlockState(pos.below()));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction preferredSide = this.getPreferredHorizontalFacing(context);
        if (preferredSide == null) {
            preferredSide = context.getHorizontalDirection().getOpposite();
        }
        return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)preferredSide);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() == ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public Class<MechanicalFryerEntity> getBlockEntityClass() {
        return MechanicalFryerEntity.class;
    }

    public BlockEntityType<? extends MechanicalFryerEntity> getBlockEntityType() {
        return (BlockEntityType)BlockEntityRegistry.MECHANICAL_FRYER.get();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

