/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.common.item;

import fonnymunkey.simplehats.common.item.HatItem;
import fonnymunkey.simplehats.util.HatEntry;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;

public class HatItemDyeable
extends HatItem {
    private static final String[] colorList = new String[]{"\u00a7c", "\u00a7e", "\u00a7a", "\u00a7b", "\u00a79", "\u00a7d", "\u00a75"};

    public HatItemDyeable(HatEntry entry) {
        super(entry);
    }

    public int getColor(ItemStack stack) {
        return 0xFF000000 | (stack.has(DataComponents.DYED_COLOR) ? ((DyedItemColor)stack.get(DataComponents.DYED_COLOR)).rgb() : this.getHatEntry().getHatDyeSettings().getColorCode());
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, context, tooltipComponents, tooltipFlag);
        MutableComponent component = Component.empty();
        char[] c = Component.translatable((String)"tooltip.simplehats.dyeable").getString().toCharArray();
        for (int i = 0; i < c.length; ++i) {
            component.append(colorList[i % colorList.length] + c[i]);
        }
        tooltipComponents.add((Component)component);
    }
}

