/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pane;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.pane.CornerStripSkipPredicate;

@CullTest(value={BlockType.FRAMED_FLOOR_BOARD})
public final class FloorBoardSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (!Utils.isY(side)) {
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            if (adjState.getBlock() == state.getBlock()) {
                return FloorBoardSkipPredicate.testAgainstFloorBoard(top, adjState);
            }
            if (adjState.getBlock() == FBContent.BLOCK_FRAMED_CORNER_STRIP.value()) {
                return FloorBoardSkipPredicate.testAgainstCornerStrip(top, adjState, side);
            }
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLOOR_BOARD})
    private static boolean testAgainstFloorBoard(boolean top, BlockState adjState) {
        return top == (Boolean)adjState.getValue((Property)FramedProperties.TOP);
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_STRIP})
    private static boolean testAgainstCornerStrip(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        return FloorBoardSkipPredicate.getHalfDir(top, side).isEqualTo(CornerStripSkipPredicate.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    public static HalfDir getHalfDir(boolean top, Direction side) {
        if (!Utils.isY(side)) {
            return HalfDir.fromDirections(side, top ? Direction.UP : Direction.DOWN);
        }
        return HalfDir.NULL;
    }
}

