/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.door;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.block.door.FramedTrapDoorBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;

@CullTest(value={BlockType.FRAMED_TRAPDOOR})
public final class TrapdoorSkipPredicate
implements SideSkipPredicate {
    @Override
    @CullTest.TestTarget(value={BlockType.FRAMED_TRAPDOOR})
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction facing = TrapdoorSkipPredicate.getTrapDoorFacing(state);
        if (side != facing.getOpposite() && adjState.getBlock() instanceof FramedTrapDoorBlock) {
            return facing == TrapdoorSkipPredicate.getTrapDoorFacing(adjState);
        }
        return false;
    }

    private static Direction getTrapDoorFacing(BlockState state) {
        if (((Boolean)state.getValue((Property)TrapDoorBlock.OPEN)).booleanValue()) {
            return (Direction)state.getValue((Property)TrapDoorBlock.FACING);
        }
        if (state.getValue((Property)TrapDoorBlock.HALF) == Half.BOTTOM) {
            return Direction.UP;
        }
        return Direction.DOWN;
    }
}

