/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.camo.block.rotator;

import com.google.common.base.Stopwatch;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.camo.CamoContainerFactory;
import xfacthd.framedblocks.api.camo.block.AbstractBlockCamoContainerFactory;
import xfacthd.framedblocks.api.camo.block.rotator.BlockCamoRotator;
import xfacthd.framedblocks.api.camo.block.rotator.RegisterBlockCamoRotatorsEvent;
import xfacthd.framedblocks.api.camo.block.rotator.SimpleBlockCamoRotator;
import xfacthd.framedblocks.common.data.camo.CamoContainerFactories;

public final class BlockCamoRotators {
    private static final Reference2ObjectMap<Block, BlockCamoRotator> ROTATORS = new Reference2ObjectOpenHashMap();
    private static final BlockCamoRotator AXIS = new SimpleBlockCamoRotator((Property<?>)RotatedPillarBlock.AXIS);
    private static final BlockCamoRotator DIR = new SimpleBlockCamoRotator((Property<?>)DirectionalBlock.FACING);
    private static final BlockCamoRotator HOR_DIR = new SimpleBlockCamoRotator((Property<?>)HorizontalDirectionalBlock.FACING);
    private static final BlockCamoRotator REDSTONE_LAMP = new SimpleBlockCamoRotator((Property<?>)RedstoneLampBlock.LIT);

    public static BlockCamoRotator get(Block block) {
        return (BlockCamoRotator)ROTATORS.getOrDefault((Object)block, (Object)BlockCamoRotator.DEFAULT);
    }

    public static void reload() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        BuiltInRegistries.BLOCK.forEach(block -> {
            ItemStack stack = block.asItem().getDefaultInstance();
            if (stack.isEmpty()) {
                return;
            }
            CamoContainerFactory<?> factory = CamoContainerFactories.findCamoFactory(stack);
            if (!(factory instanceof AbstractBlockCamoContainerFactory)) {
                return;
            }
            AbstractBlockCamoContainerFactory blockFactory = (AbstractBlockCamoContainerFactory)factory;
            if (!blockFactory.isValidBlockInternal(block.defaultBlockState())) {
                return;
            }
            Block block2 = block;
            Objects.requireNonNull(block2);
            Block selector0$temp = block2;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RotatedPillarBlock.class, DirectionalBlock.class, HorizontalDirectionalBlock.class, RedstoneLampBlock.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    RotatedPillarBlock ignored = (RotatedPillarBlock)selector0$temp;
                    BlockCamoRotators.addIfPropPresent(block, RotatedPillarBlock.AXIS, AXIS);
                    break;
                }
                case 1: {
                    DirectionalBlock ignored = (DirectionalBlock)selector0$temp;
                    BlockCamoRotators.addIfPropPresent(block, DirectionalBlock.FACING, DIR);
                    break;
                }
                case 2: {
                    HorizontalDirectionalBlock ignored = (HorizontalDirectionalBlock)selector0$temp;
                    BlockCamoRotators.addIfPropPresent(block, HorizontalDirectionalBlock.FACING, HOR_DIR);
                    break;
                }
                case 3: {
                    RedstoneLampBlock ignored = (RedstoneLampBlock)selector0$temp;
                    BlockCamoRotators.addIfPropPresent(block, RedstoneLampBlock.LIT, REDSTONE_LAMP);
                    break;
                }
            }
        });
        int autoSize = ROTATORS.size();
        NeoForge.EVENT_BUS.post((Event)new RegisterBlockCamoRotatorsEvent((block, rotator) -> {
            if (ROTATORS.putIfAbsent(block, rotator) != null) {
                throw new IllegalStateException("Duplicate BlockCamoRotator registration for block " + String.valueOf(block));
            }
        }));
        stopwatch.stop();
        FramedBlocks.LOGGER.debug("Collected {} default camo rotators and {} custom camo rotators in {}", new Object[]{autoSize, ROTATORS.size() - autoSize, stopwatch});
    }

    private static void addIfPropPresent(Block block, Property<?> property, BlockCamoRotator rotator) {
        if (block.defaultBlockState().hasProperty(property)) {
            ROTATORS.put((Object)block, (Object)rotator);
        }
    }

    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)((ResourceManagerReloadListener)$ -> BlockCamoRotators.reload()));
    }

    private BlockCamoRotators() {
    }
}

