/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.ae2;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsTooltip;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.common.compat.ae2.AppliedEnergisticsCompat;
import xfacthd.framedblocks.common.compat.ae2.EncodedFramingSawPattern;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCalculation;

final class FramingSawPatternDetails
implements IPatternDetails {
    private final AEItemKey definition;
    private final RecipeHolder<FramingSawRecipe> recipe;
    private final IPatternDetails.IInput[] inputs;
    private final List<GenericStack> outputs;

    FramingSawPatternDetails(AEItemKey definition, Level level) {
        this.definition = definition;
        EncodedFramingSawPattern pattern = (EncodedFramingSawPattern)definition.get((DataComponentType)AppliedEnergisticsCompat.GuardedAccess.DC_TYPE_ENCODED_SAW_PATTERN.get());
        if (pattern == null) {
            throw new IllegalArgumentException("Given item does not encode a processing pattern: " + String.valueOf(definition));
        }
        this.recipe = Objects.requireNonNull(FramingSawRecipeCache.get(level.isClientSide()).findRecipeFor(pattern.output()));
        FramingSawRecipe recipe = (FramingSawRecipe)this.recipe.value();
        SingleRecipeInput container = new SingleRecipeInput(pattern.input());
        FramingSawRecipeCalculation calc = recipe.makeCraftingCalculation((RecipeInput)container, level.isClientSide());
        List<FramingSawRecipeAdditive> additives = recipe.getAdditives();
        this.inputs = new IPatternDetails.IInput[1 + additives.size()];
        this.inputs[0] = new Input(pattern.input(), calc.getInputCount());
        List<ItemStack> loadedAdditives = pattern.additives();
        if (additives.size() != loadedAdditives.size()) {
            throw new IllegalArgumentException("Additive count does not match. Pattern: %d Recipe: %d".formatted(loadedAdditives.size(), additives.size()));
        }
        for (int i = 0; i < additives.size(); ++i) {
            if (!additives.get(i).ingredient().test(loadedAdditives.get(i))) {
                throw new IllegalArgumentException("Invalid additive '%s' in slot '%d' for recipe '%s'".formatted(loadedAdditives.get(i), i, this.recipe.id()));
            }
            this.inputs[i + 1] = new Input(loadedAdditives.get(i), calc.getAdditiveCount(i));
        }
        this.outputs = List.of(new GenericStack((AEKey)Objects.requireNonNull(AEItemKey.of((ItemStack)pattern.output())), (long)calc.getOutputCount()));
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    public List<GenericStack> getOutputs() {
        return this.outputs;
    }

    public boolean supportsPushInputsToExternalInventory() {
        return false;
    }

    public RecipeHolder<FramingSawRecipe> getRecipe() {
        return this.recipe;
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((FramingSawPatternDetails)obj).definition.equals((Object)this.definition);
    }

    public static void encode(ItemStack stack, ItemStack input, ItemStack[] additives, ItemStack output) {
        stack.set(AppliedEnergisticsCompat.GuardedAccess.DC_TYPE_ENCODED_SAW_PATTERN, (Object)new EncodedFramingSawPattern(input, Arrays.stream(additives).filter(additive -> !additive.isEmpty()).toList(), output));
    }

    public static PatternDetailsTooltip makeInvalidPatternTooltip(ItemStack stack, Level level, @Nullable Exception cause, TooltipFlag flags) {
        PatternDetailsTooltip tooltip = new PatternDetailsTooltip(PatternDetailsTooltip.OUTPUT_TEXT_PRODUCES);
        EncodedFramingSawPattern pattern = (EncodedFramingSawPattern)stack.get(AppliedEnergisticsCompat.GuardedAccess.DC_TYPE_ENCODED_SAW_PATTERN);
        if (pattern != null) {
            RecipeHolder<FramingSawRecipe> recipe;
            tooltip.addInput((AEKey)AEItemKey.of((ItemStack)pattern.input()), 1L);
            pattern.additives().forEach(additive -> {
                if (!additive.isEmpty()) {
                    tooltip.addInput((AEKey)AEItemKey.of((ItemStack)additive), (long)additive.getCount());
                }
            });
            tooltip.addOutput((AEKey)AEItemKey.of((ItemStack)pattern.output()), 1L);
            if (flags.isAdvanced() && !pattern.output().isEmpty() && (recipe = FramingSawRecipeCache.get(level.isClientSide()).findRecipeFor(pattern.output())) != null) {
                tooltip.addProperty((Component)Component.literal((String)"Recipe"), (Component)Component.literal((String)recipe.id().toString()));
            }
        }
        return tooltip;
    }

    private static final class Input
    implements IPatternDetails.IInput {
        private final GenericStack[] input = new GenericStack[1];
        private final long multiplier;

        public Input(ItemStack input, int multiplier) {
            this.input[0] = new GenericStack((AEKey)Objects.requireNonNull(AEItemKey.of((ItemStack)input)), 1L);
            this.multiplier = multiplier;
        }

        public GenericStack[] getPossibleInputs() {
            return this.input;
        }

        public long getMultiplier() {
            return this.multiplier;
        }

        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.input[0]);
        }

        @Nullable
        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

