/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pillar;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;

public class FramedCornerPillarGeometry
extends Geometry {
    private final Direction dir;

    public FramedCornerPillarGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (quadDir == this.dir || quadDir == this.dir.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), 0.5f)).applyIf(Modifiers.setPosition(0.5f), quadDir != this.dir).export(quadMap.get((Direction)(quadDir == this.dir ? quadDir : null)));
        } else if (quadDir == this.dir.getClockWise() || quadDir == this.dir.getCounterClockWise()) {
            boolean isCCW = quadDir == this.dir.getCounterClockWise();
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.5f)).applyIf(Modifiers.setPosition(0.5f), !isCCW).export(quadMap.get((Direction)(isCCW ? quadDir : null)));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.5f)).export(quadMap.get(quadDir));
        }
    }
}

