/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.datagen.loot.objects;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.neoforge.registries.DeferredHolder;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.util.Utils;

public final class NonTrivialCamoLootCondition
implements LootItemCondition {
    public static final NonTrivialCamoLootCondition INSTANCE = new NonTrivialCamoLootCondition();
    public static final MapCodec<NonTrivialCamoLootCondition> MAP_CODEC = MapCodec.unit((Object)INSTANCE);
    public static final LootItemCondition.Builder BUILDER = () -> INSTANCE;
    private static final Holder<LootItemConditionType> TYPE = DeferredHolder.create((ResourceKey)Registries.LOOT_CONDITION_TYPE, (ResourceLocation)Utils.rl("non_trivial_camo"));

    private NonTrivialCamoLootCondition() {
    }

    public boolean test(LootContext ctx) {
        Object object = ctx.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (object instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)((Object)object);
            return !be.canTriviallyDropAllCamos();
        }
        return false;
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)TYPE.value();
    }
}

