/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.camo.block;

import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.camo.block.AbstractBlockCamoContainer;
import xfacthd.framedblocks.api.camo.block.AbstractBlockCamoContainerFactory;
import xfacthd.framedblocks.api.camo.block.SimpleBlockCamoContainer;
import xfacthd.framedblocks.api.util.ConfigView;

public abstract class SimpleBlockCamoContainerFactory
extends AbstractBlockCamoContainerFactory<SimpleBlockCamoContainer> {
    private final MapCodec<SimpleBlockCamoContainer> codec = BlockState.CODEC.xmap(state -> new SimpleBlockCamoContainer((BlockState)state, this), AbstractBlockCamoContainer::getState).fieldOf("state");
    private final StreamCodec<ByteBuf, SimpleBlockCamoContainer> streamCodec = ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY).map(state -> new SimpleBlockCamoContainer((BlockState)state, this), AbstractBlockCamoContainer::getState);

    @Override
    public ItemStack dropCamo(SimpleBlockCamoContainer container) {
        return new ItemStack((ItemLike)container.getState().getBlock());
    }

    @Override
    public boolean canApplyInCraftingRecipe(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            BlockState state = item2.getBlock().defaultBlockState();
            return this.isValidBlock(state, (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO, null);
        }
        return false;
    }

    @Override
    public SimpleBlockCamoContainer applyCamoInCraftingRecipe(ItemStack stack) {
        BlockItem item;
        BlockState state;
        Item item2 = stack.getItem();
        if (item2 instanceof BlockItem && this.isValidBlock(state = (item = (BlockItem)item2).getBlock().defaultBlockState(), (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO, null)) {
            return new SimpleBlockCamoContainer(item.getBlock().defaultBlockState(), this);
        }
        throw new IllegalStateException("applyCamoInCraftingRecipe() called without canApplyInCraftingRecipe() check");
    }

    @Override
    public ItemStack getCraftingRemainder(ItemStack stack) {
        if (!ConfigView.Server.INSTANCE.shouldConsumeCamoItem()) {
            return stack.copy();
        }
        return ItemStack.EMPTY;
    }

    @Override
    protected final SimpleBlockCamoContainer createContainer(BlockState camoState, Level level, BlockPos pos, Player player, ItemStack stack) {
        return new SimpleBlockCamoContainer(camoState, this);
    }

    @Override
    protected final SimpleBlockCamoContainer copyContainerWithState(SimpleBlockCamoContainer original, BlockState newCamoState) {
        return new SimpleBlockCamoContainer(newCamoState, this);
    }

    @Override
    protected final ItemStack createItemStack(Level level, BlockPos pos, Player player, ItemStack stack, SimpleBlockCamoContainer container) {
        return this.dropCamo(container);
    }

    @Override
    public final boolean canTriviallyConvertToItemStack() {
        return true;
    }

    @Override
    protected final void writeToNetwork(CompoundTag tag, SimpleBlockCamoContainer container) {
        tag.putInt("state", Block.getId((BlockState)container.getState()));
    }

    @Override
    protected final SimpleBlockCamoContainer readFromNetwork(CompoundTag tag) {
        return new SimpleBlockCamoContainer(Block.stateById((int)tag.getInt("state")), this);
    }

    @Override
    public final MapCodec<SimpleBlockCamoContainer> codec() {
        return this.codec;
    }

    @Override
    public final StreamCodec<? super RegistryFriendlyByteBuf, SimpleBlockCamoContainer> streamCodec() {
        return this.streamCodec;
    }
}

