/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbjeiextras.oritech;

import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.recipes.OritechRecipe;

public class OritechParticleCollisionRecipe
implements IRecipeCategory<RecipeHolder<OritechRecipe>> {
    private static final ResourceLocation PARTICLE = Oritech.id((String)"textures/gui/modular/particle_recipe_overlay.png");
    private final IGuiHelper guiHelper;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;
    private final IDrawable particle;
    private final RecipeType<RecipeHolder<OritechRecipe>> recipeType;

    public OritechParticleCollisionRecipe(IJeiHelpers helpers, RecipeType<RecipeHolder<OritechRecipe>> recipeType) {
        this.guiHelper = helpers.getGuiHelper();
        this.icon = this.guiHelper.createDrawableItemStack(new ItemStack((ItemLike)BlockContent.ACCELERATOR_CONTROLLER));
        this.background = this.guiHelper.createBlankDrawable(150, 66);
        this.recipeType = recipeType;
        this.title = Component.translatable((String)("emi.category.oritech." + recipeType.getUid().getPath()));
        this.particle = this.guiHelper.drawableBuilder(PARTICLE, 0, 0, 36, 24).setTextureSize(36, 24).build();
    }

    public RecipeType<RecipeHolder<OritechRecipe>> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<OritechRecipe> recipeHolder, IFocusGroup focuses) {
        OritechRecipe recipe = (OritechRecipe)recipeHolder.value();
        builder.addSlot(RecipeIngredientRole.INPUT, 42, 20).addIngredients((Ingredient)recipe.getInputs().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 20).addIngredients((Ingredient)recipe.getInputs().get(1));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 69, 20).addItemStack((ItemStack)recipe.getResults().get(0));
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<OritechRecipe> recipeHolder, IFocusGroup focuses) {
        OritechRecipe recipe = (OritechRecipe)recipeHolder.value();
        ITextWidget iTextWidget = builder.addText((FormattedText)Component.translatable((String)"emi.title.oritech.collisionspeed", (Object[])new Object[]{recipe.getTime()}), this.getWidth(), this.getHeight()).setShadow(true).setTextAlignment(HorizontalAlignment.CENTER).setColor(0xFFFFFF);
        int n = this.getHeight();
        Objects.requireNonNull(Minecraft.getInstance().font);
        iTextWidget.setPosition(0, n - 9 * 2);
    }

    public void draw(RecipeHolder<OritechRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.particle.draw(guiGraphics, 59, 17);
        this.guiHelper.getSlotDrawable().draw(guiGraphics, 41, 19);
        this.guiHelper.getSlotDrawable().draw(guiGraphics, 95, 19);
    }
}

