/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.registration.data;

import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.ConnectingModelData;
import com.supermartijn642.fusion.api.model.data.ConnectingModelDataBuilder;
import com.supermartijn642.fusion.api.predicate.DefaultConnectionPredicates;
import com.supermartijn642.fusion.api.provider.FusionModelProvider;
import com.supermartijn642.rechiseled.api.blocks.BlockModelType;
import com.supermartijn642.rechiseled.blocks.RechiseledBlockBuilderImpl;
import com.supermartijn642.rechiseled.blocks.RechiseledBlockTypeImpl;
import com.supermartijn642.rechiseled.registration.RechiseledRegistrationImpl;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class RegistrationFusionModelProvider
extends FusionModelProvider {
    private final RechiseledRegistrationImpl registration;

    public RegistrationFusionModelProvider(RechiseledRegistrationImpl registration, PackOutput output) {
        super(registration.getModid(), output);
        this.registration = registration;
    }

    protected void generate() {
        if (!this.registration.providersRegistered) {
            return;
        }
        this.registration.getBlockBuilders().forEach(pair -> {
            BlockModelType modelType;
            RechiseledBlockBuilderImpl builder = (RechiseledBlockBuilderImpl)pair.left();
            RechiseledBlockTypeImpl type = (RechiseledBlockTypeImpl)pair.right();
            BlockModelType blockModelType = modelType = builder.modelType == null ? type.getSpecification().getDefaultModelType() : builder.modelType;
            if (type.hasConnectingVariant()) {
                this.addModel(modelType, type.getConnectingBlock(), type.getIdentifier().getPath());
            }
        });
    }

    private void addModel(BlockModelType modelType, Block block, String texture) {
        String namespace = Registries.BLOCKS.getIdentifier((Object)block).getNamespace();
        String identifier = Registries.BLOCKS.getIdentifier((Object)block).getPath();
        if (modelType == BlockModelType.CUBE) {
            ConnectingModelDataBuilder builder = (ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/cube"))).texture("up", ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + texture + "_up")))).texture("down", ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + texture + "_down")))).texture("north", ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + texture + "_north")))).texture("east", ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + texture + "_east")))).texture("south", ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + texture + "_south")))).texture("west", ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + texture + "_west")))).texture("particle", ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + texture + "_up")));
            ModelInstance model = ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)builder.build()));
            this.addModel(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + identifier)), model);
        } else if (modelType == BlockModelType.CUBE_ALL) {
            ConnectingModelDataBuilder builder = ((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/cube_all"))).texture("all", ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + texture)))).connection(DefaultConnectionPredicates.isSameBlock());
            ModelInstance model = ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)builder.build()));
            this.addModel(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + identifier)), model);
        } else if (modelType == BlockModelType.PILLAR) {
            ConnectingModelDataBuilder builder = ((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/cube"))).texture("up", ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + texture + "_end")))).texture("down", ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + texture + "_end")))).texture("north", ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + texture + "_side")))).texture("east", ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + texture + "_side")))).texture("south", ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + texture + "_side")))).texture("west", ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + texture + "_side")))).texture("particle", ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + texture + "_side")))).connection(DefaultConnectionPredicates.isSameState());
            ModelInstance model = ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)builder.build()));
            this.addModel(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + identifier)), model);
        }
    }

    public String getName() {
        return "Registration Fusion Model Generator: " + this.registration.getModid();
    }
}

