/*
 * Decompiled with CFR 0.152.
 */
package com.mcwholidays.kikoz.objects.christmas;

import com.mcwholidays.kikoz.objects.FacingBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SlimCane
extends FacingBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final EnumProperty<CandyPart> PART = EnumProperty.create((String)"part", CandyPart.class);
    public static final VoxelShape EAST = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)6.0, (double)4.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[0]);
    public static final VoxelShape SOUTH = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
    public static final VoxelShape WEST = Shapes.or((VoxelShape)Block.box((double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[0]);
    public static final VoxelShape NORTH = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)12.0, (double)10.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    public static final VoxelShape TOP_E = Shapes.or((VoxelShape)Block.box((double)4.0, (double)12.0, (double)6.0, (double)8.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)6.0, (double)4.0, (double)14.0, (double)10.0), Block.box((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)14.0, (double)10.0), Block.box((double)12.0, (double)14.0, (double)6.0, (double)14.0, (double)15.0, (double)10.0), Block.box((double)2.0, (double)14.0, (double)6.0, (double)4.0, (double)15.0, (double)10.0), Block.box((double)10.0, (double)11.0, (double)6.0, (double)12.0, (double)12.0, (double)10.0), Block.box((double)4.0, (double)11.0, (double)6.0, (double)6.0, (double)12.0, (double)10.0), Block.box((double)8.0, (double)12.0, (double)6.0, (double)12.0, (double)16.0, (double)10.0)});
    public static final VoxelShape TOP_S = Shapes.or((VoxelShape)Block.box((double)6.0, (double)12.0, (double)4.0, (double)10.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)14.0, (double)4.0), Block.box((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)14.0, (double)16.0), Block.box((double)6.0, (double)14.0, (double)12.0, (double)10.0, (double)15.0, (double)14.0), Block.box((double)6.0, (double)14.0, (double)2.0, (double)10.0, (double)15.0, (double)4.0), Block.box((double)6.0, (double)11.0, (double)10.0, (double)10.0, (double)12.0, (double)12.0), Block.box((double)6.0, (double)11.0, (double)4.0, (double)10.0, (double)12.0, (double)6.0), Block.box((double)6.0, (double)12.0, (double)8.0, (double)10.0, (double)16.0, (double)12.0)});
    public static final VoxelShape TOP_W = Shapes.or((VoxelShape)Block.box((double)8.0, (double)12.0, (double)6.0, (double)12.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.box((double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)14.0, (double)10.0), Block.box((double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)14.0, (double)10.0), Block.box((double)2.0, (double)14.0, (double)6.0, (double)4.0, (double)15.0, (double)10.0), Block.box((double)12.0, (double)14.0, (double)6.0, (double)14.0, (double)15.0, (double)10.0), Block.box((double)4.0, (double)11.0, (double)6.0, (double)6.0, (double)12.0, (double)10.0), Block.box((double)10.0, (double)11.0, (double)6.0, (double)12.0, (double)12.0, (double)10.0), Block.box((double)4.0, (double)12.0, (double)6.0, (double)8.0, (double)16.0, (double)10.0)});
    public static final VoxelShape TOP_N = Shapes.or((VoxelShape)Block.box((double)6.0, (double)12.0, (double)8.0, (double)10.0, (double)16.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)0.0, (double)12.0, (double)10.0, (double)14.0, (double)16.0), Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)14.0, (double)4.0), Block.box((double)6.0, (double)14.0, (double)2.0, (double)10.0, (double)15.0, (double)4.0), Block.box((double)6.0, (double)14.0, (double)12.0, (double)10.0, (double)15.0, (double)14.0), Block.box((double)6.0, (double)11.0, (double)4.0, (double)10.0, (double)12.0, (double)6.0), Block.box((double)6.0, (double)11.0, (double)10.0, (double)10.0, (double)12.0, (double)12.0), Block.box((double)6.0, (double)12.0, (double)4.0, (double)10.0, (double)16.0, (double)8.0)});

    public SlimCane(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)CandyPart.BOTTOM)));
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return state.getValue(PART) == CandyPart.BOTTOM ? NORTH : TOP_N;
            }
            case EAST: {
                return state.getValue(PART) == CandyPart.BOTTOM ? EAST : TOP_E;
            }
            case SOUTH: {
                return state.getValue(PART) == CandyPart.BOTTOM ? SOUTH : TOP_S;
            }
            case WEST: {
                return state.getValue(PART) == CandyPart.BOTTOM ? WEST : TOP_W;
            }
        }
        return Shapes.empty();
    }

    protected BlockState CandyState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean below;
        boolean above = level.getBlockState(pos.above()).getBlock() == this;
        boolean bl = below = level.getBlockState(pos.below()).getBlock() == this;
        if (above && below) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)CandyPart.BOTTOM));
        }
        if (!above && below) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)CandyPart.TOP));
        }
        if (above && !below) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)CandyPart.BOTTOM));
        }
        return (BlockState)state.setValue(PART, (Comparable)((Object)CandyPart.TOP));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.is(state.getBlock())) {
            this.CandyState(state, (LevelAccessor)level, pos);
        }
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.CandyState(super.getStateForPlacement(context), (LevelAccessor)context.getLevel(), context.getClickedPos()).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void placeAt(Level level, BlockPos pos, int num) {
        level.setBlock(pos, this.defaultBlockState(), num);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.CandyState(state, level, pos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART});
    }

    @Override
    public void onBroken(Level worldIn, BlockPos pos) {
        worldIn.levelEvent(1029, pos, 0);
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public static enum CandyPart implements StringRepresentable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private CandyPart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

