/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.stairs;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Stairs {
    public static final String modid = "mcwstairs";

    public static void setRegistrationWood(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        BlockBehaviour.Properties WOOD = BlockBehaviour.Properties.of().strength(2.0f, 2.3f).sound(SoundType.WOOD);
        Stairs.setRegistrationWoodModLoaded(set, block, item, WOOD);
    }

    public static void setRegistrationRock(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        BlockBehaviour.Properties STONE = BlockBehaviour.Properties.of().strength(2.0f, 2.3f).sound(SoundType.STONE).requiresCorrectToolForDrops();
        Stairs.setRegistrationRockModLoaded(set, block, item, STONE);
    }

    public static void setRegistrationRockModLoaded(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        boolean isModLoaded = ModList.get().isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.STAIRS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModLoaded) {
                    CreateBlockReferences.createBlockStone(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), STONE), block, item);
                    continue;
                }
                CreateBlockReferences.createBlockStone(id, registryName -> new Block(STONE), block, item);
            }
        }
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        boolean isModLoaded = ModList.get().isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.STAIRS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModLoaded) {
                    CreateBlockReferences.createBlock(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, registryName -> new Block(WOOD), block, item);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void addToTab(BuildCreativeModeTabContentsEvent event, String MODID, List<String> WOOD, CreativeModeTab tab) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid)) {
            for (String i : WOOD) {
                Block _terrace_stairs = Finder.findBlock(MODID, i + "_terrace_stairs");
                Block _skyline_stairs = Finder.findBlock(MODID, i + "_skyline_stairs");
                Block _compact_stairs = Finder.findBlock(MODID, i + "_compact_stairs");
                Block _bulk_stairs = Finder.findBlock(MODID, i + "_bulk_stairs");
                Block _loft_stairs = Finder.findBlock(MODID, i + "_loft_stairs");
                Block _railing = Finder.findBlock(MODID, i + "_railing");
                Block _balcony = Finder.findBlock(MODID, i + "_balcony");
                Block _platform = Finder.findBlock(MODID, i + "_platform");
                event.accept((ItemLike)_terrace_stairs);
                event.accept((ItemLike)_skyline_stairs);
                event.accept((ItemLike)_compact_stairs);
                event.accept((ItemLike)_bulk_stairs);
                event.accept((ItemLike)_loft_stairs);
                event.accept((ItemLike)_railing);
                event.accept((ItemLike)_balcony);
                event.accept((ItemLike)_platform);
            }
        }
    }
}

