/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.ingame;

import io.github.kosmx.emotes.arch.gui.widgets.EmoteListWidget;
import io.github.kosmx.emotes.arch.screen.EmoteMenu;
import io.github.kosmx.emotes.arch.screen.components.EmoteSubScreen;
import io.github.kosmx.emotes.arch.screen.ingame.FastMenuScreen;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.emotePlay.EmotePlayer;
import io.github.kosmx.emotes.main.mixinFunctions.IPlayerEntity;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class FullMenuScreen
extends EmoteSubScreen {
    protected static final Component TITLE = Component.translatable((String)"emotecraft.emotelist");
    protected static final Component CONFIG = Component.translatable((String)"emotecraft.config");

    public FullMenuScreen(Screen parent) {
        super(TITLE, parent);
    }

    @Override
    protected void addOptions() {
        this.list.setEmotes((Iterable<EmoteHolder>)EmoteHolder.list, false);
    }

    @Override
    protected void addFooter() {
        LinearLayout linearLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        linearLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).build());
        linearLayout.addChild((LayoutElement)Button.builder((Component)CONFIG, button -> this.minecraft.setScreen((Screen)new EmoteMenu(this))).build());
    }

    @Override
    protected void onPressed(EmoteListWidget.EmoteEntry selected) {
        if (selected != null) {
            ClientEmotePlay.clientStartLocalEmote(selected.getEmote());
            Screen screen = this.lastScreen;
            if (screen instanceof FastMenuScreen) {
                FastMenuScreen fast = (FastMenuScreen)screen;
                this.lastScreen = fast.parent;
            }
        }
    }

    protected void renderBlurredBackground(float f) {
        LocalPlayer entity;
        LocalPlayer localPlayer = this.minecraft.player;
        if (localPlayer instanceof IPlayerEntity && EmotePlayer.isRunningEmote((entity = localPlayer).emotecraft$getEmote())) {
            return;
        }
        super.renderBlurredBackground(f);
    }

    @Override
    protected void repositionElements() {
        this.addOptions();
        super.repositionElements();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

