/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block;

import com.soytutta.mynethersdelight.common.block.PowderyCaneBlock;
import com.soytutta.mynethersdelight.common.block.PowderyFlowerBlock;
import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.WitherRoseBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.util.TriState;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.block.MushroomColonyBlock;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class ResurgentSoilBlock
extends Block {
    public ResurgentSoilBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!level.isClientSide) {
            BlockPos abovePos = pos.above();
            BlockState aboveState = level.getBlockState(abovePos);
            Block aboveBlock = aboveState.getBlock();
            BlockPos belowPos = pos.below();
            BlockState belowState = level.getBlockState(belowPos);
            Block belowBlock = belowState.getBlock();
            if (aboveBlock == Blocks.CRIMSON_FUNGUS) {
                level.setBlockAndUpdate(pos.above(), MNDBlocks.CRIMSON_FUNGUS_COLONY.get().defaultBlockState());
                return;
            }
            if (aboveBlock == Blocks.WARPED_FUNGUS) {
                level.setBlockAndUpdate(pos.above(), MNDBlocks.WARPED_FUNGUS_COLONY.get().defaultBlockState());
                return;
            }
            if (aboveBlock == Blocks.BROWN_MUSHROOM) {
                level.setBlockAndUpdate(pos.above(), ((Block)ModBlocks.BROWN_MUSHROOM_COLONY.get()).defaultBlockState());
                return;
            }
            if (aboveBlock == Blocks.RED_MUSHROOM) {
                level.setBlockAndUpdate(pos.above(), ((Block)ModBlocks.RED_MUSHROOM_COLONY.get()).defaultBlockState());
                return;
            }
            if ((Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() == 0.0) {
                return;
            }
            if (aboveBlock == MNDBlocks.POWDERY_TORCH.get() && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() / 15.0 && level.isEmptyBlock(pos.above(2))) {
                level.setBlockAndUpdate(pos.above(), (BlockState)MNDBlocks.POWDERY_CANE.get().defaultBlockState().setValue((Property)PowderyCaneBlock.BASE, (Comparable)Boolean.valueOf(true)));
                level.setBlockAndUpdate(pos.above(2), (BlockState)((BlockState)MNDBlocks.BULLET_PEPPER.get().defaultBlockState().setValue((Property)PowderyFlowerBlock.LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)PowderyFlowerBlock.AGE, (Comparable)Integer.valueOf(2)));
                return;
            }
            if (!aboveState.is(MNDTags.NOT_PROPAGATE_PLANT)) {
                if (aboveState.is(MNDTags.ABOVE_PROPAGATE_PLANT) && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.6f) {
                    this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    return;
                }
                if (aboveBlock instanceof FlowerBlock && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.8f) {
                    this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    return;
                }
                if ((aboveBlock instanceof FungusBlock || aboveBlock instanceof MushroomBlock) && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.4f) {
                    this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    return;
                }
                if (aboveBlock instanceof MushroomColonyBlock) {
                    int age = (Integer)aboveState.getValue((Property)MushroomColonyBlock.COLONY_AGE);
                    if (age == 3 && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.4f) {
                        this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    }
                    return;
                }
                if (aboveBlock instanceof NetherWartBlock) {
                    int age = (Integer)aboveState.getValue((Property)NetherWartBlock.AGE);
                    if (age < 3) {
                        return;
                    }
                    if (age == 3 && level.random.nextInt(8) == 0) {
                        this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    }
                    return;
                }
                if (aboveBlock instanceof PinkPetalsBlock) {
                    int age = (Integer)aboveState.getValue((Property)PinkPetalsBlock.AMOUNT);
                    if (age != 4) {
                        this.performBonemealIfPossible(aboveBlock, pos.above(), aboveState, level, 1);
                    } else if (level.random.nextInt(6) == 0) {
                        this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    }
                    return;
                }
                if (aboveBlock instanceof DoublePlantBlock && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() / 2.0) {
                    this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    return;
                }
                if (aboveBlock instanceof BushBlock && !(aboveBlock instanceof DoublePlantBlock) && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() / 3.0) {
                    this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    return;
                }
            }
            if (!belowState.is(MNDTags.NOT_PROPAGATE_PLANT) && belowState.is(MNDTags.BELOW_PROPAGATE_PLANT) && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.8f) {
                this.propagateBelowIfPossible(belowBlock, belowPos, level);
                return;
            }
            if (!(belowBlock instanceof CaveVinesBlock) && !(belowBlock instanceof CaveVinesPlantBlock) && (belowBlock instanceof GrowingPlantHeadBlock || belowBlock instanceof GrowingPlantBodyBlock) && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.2f) {
                this.performBonemealIfPossible(belowBlock, pos.below(), belowState, level, 1);
            }
            if ((aboveBlock instanceof GrowingPlantHeadBlock || aboveBlock instanceof GrowingPlantBodyBlock) && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.2f) {
                this.performBonemealIfPossible(aboveBlock, pos.above(), aboveState, level, 1);
            }
            int BonemealChance = 1;
            if (MathUtils.RAND.nextFloat() <= 0.2f) {
                BonemealChance = 2;
                if (MathUtils.RAND.nextFloat() <= 0.01f) {
                    BonemealChance = 3;
                }
            }
            for (int i = 0; i < MathUtils.RAND.nextInt(BonemealChance) + 1; ++i) {
                this.performBonemealIfPossible(aboveBlock, pos.above(), aboveState, level, 1);
                this.performBonemealIfPossible(belowBlock, pos.below(), belowState, level, 1);
            }
            ResurgentSoilBlock.growIfPossible(aboveState, abovePos, level, Blocks.SUGAR_CANE, 7);
            ResurgentSoilBlock.growIfPossible(aboveState, abovePos, level, Blocks.CACTUS, 7);
        }
    }

    private void performBonemealIfPossible(Block block, BlockPos position, BlockState state, ServerLevel level, int distance) {
        block7: {
            if (state.is(ModTags.UNAFFECTED_BY_RICH_SOIL) || block instanceof TallFlowerBlock) {
                return;
            }
            if (!(block instanceof BonemealableBlock)) break block7;
            BonemealableBlock growable = (BonemealableBlock)block;
            if ((double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() / (double)distance) {
                if (growable.isValidBonemealTarget((LevelReader)level, position.above(), state) && CommonHooks.canCropGrow((Level)level, (BlockPos)position.above(), (BlockState)state, (boolean)true)) {
                    growable.performBonemeal(level, level.random, position, state);
                    CommonHooks.fireCropGrowPost((Level)level, (BlockPos)position, (BlockState)state);
                    for (int i = 0; i < 3; ++i) {
                        double d0 = (double)position.getX() + level.getRandom().nextDouble();
                        double d1 = (double)position.getY() + level.getRandom().nextDouble();
                        double d2 = (double)position.getZ() + level.getRandom().nextDouble();
                        level.sendParticles((ParticleOptions)ParticleTypes.SOUL, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                        level.playSound(null, position, (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    BlockPos checkPos = position.above();
                    BlockState checkState = level.getBlockState(checkPos);
                    Block checkBlock = checkState.getBlock();
                    while (checkBlock == block && distance <= 10) {
                        this.performBonemealIfPossible(checkBlock, checkPos, checkState, level, distance + 1);
                        ++distance;
                        checkPos = checkPos.above();
                        checkState = level.getBlockState(checkPos);
                        checkBlock = checkState.getBlock();
                    }
                    checkPos = position.below();
                    checkState = level.getBlockState(checkPos);
                    checkBlock = checkState.getBlock();
                    while (checkBlock == block && distance <= 10) {
                        this.performBonemealIfPossible(checkBlock, checkPos, checkState, level, distance + 1);
                        ++distance;
                        checkPos = checkPos.below();
                        checkState = level.getBlockState(checkPos);
                        checkBlock = checkState.getBlock();
                    }
                }
            }
        }
    }

    public static void growIfPossible(BlockState aboveBlock, BlockPos abovePos, ServerLevel level, Block targetBlock, int maxHeight) {
        if (aboveBlock.getBlock() == targetBlock && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.6f) {
            BlockPos topPos = abovePos;
            int height = 1;
            while (level.getBlockState(topPos.above()).getBlock() == targetBlock) {
                topPos = topPos.above();
                ++height;
            }
            if (level.getBlockState(topPos.above()).isAir() && height < maxHeight) {
                level.setBlockAndUpdate(topPos.above(), targetBlock.defaultBlockState());
                for (int i = 0; i < 3; ++i) {
                    double d0 = (double)topPos.above().getX() + level.getRandom().nextDouble();
                    double d1 = (double)topPos.above().getY() + level.getRandom().nextDouble();
                    double d2 = (double)topPos.above().getZ() + level.getRandom().nextDouble();
                    level.sendParticles((ParticleOptions)ParticleTypes.SOUL, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                    level.playSound(null, topPos.above(), (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
    }

    private void propagateAboveIfPossible(Block block, BlockPos position, ServerLevel level) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos newPos = position.offset(x, y, z);
                    BlockState newState = level.getBlockState(newPos);
                    if (!this.canAboveBlockSurvive(block, newState, level, newPos)) continue;
                    validPositions.add(newPos);
                }
            }
        }
        if (!validPositions.isEmpty()) {
            boolean canPropagate;
            BlockPos plantPos = (BlockPos)validPositions.get(level.random.nextInt(validPositions.size()));
            BlockState targetState = level.getBlockState(plantPos);
            boolean bl = canPropagate = block instanceof LiquidBlockContainer && targetState.getBlock() == Blocks.WATER || !(block instanceof LiquidBlockContainer) && targetState.getBlock() == Blocks.AIR || block instanceof WitherRoseBlock && (targetState.is(BlockTags.SMALL_FLOWERS) || targetState.getBlock() instanceof FungusBlock || targetState.getBlock() instanceof MushroomBlock) || block instanceof SimpleWaterloggedBlock && (targetState.getBlock() == Blocks.AIR || targetState.getBlock() == Blocks.WATER);
            if (canPropagate) {
                this.placeBlock(block, level, plantPos);
            }
        }
    }

    private boolean canAboveBlockSurvive(Block block, BlockState newState, ServerLevel level, BlockPos newPos) {
        BlockState blockBelowState = level.getBlockState(newPos.below());
        if (block instanceof WitherRoseBlock && (newState.is(BlockTags.SMALL_FLOWERS) || newState.getBlock() instanceof FungusBlock || newState.getBlock() instanceof MushroomBlock) && !(newState.getBlock() instanceof WitherRoseBlock)) {
            return true;
        }
        if (block instanceof DoublePlantBlock) {
            BlockState doublePlantState = block.defaultBlockState();
            if ((!(block instanceof LiquidBlockContainer) || block instanceof SimpleWaterloggedBlock) && level.isEmptyBlock(newPos.above())) {
                return doublePlantState.canSurvive((LevelReader)level, newPos);
            }
            if (level.getFluidState(newPos.above()).is(FluidTags.WATER) && level.getFluidState(newPos.above()).getAmount() == 8) {
                return doublePlantState.canSurvive((LevelReader)level, newPos);
            }
        } else {
            if (block instanceof NetherWartBlock) {
                return blockBelowState.getBlock() == Blocks.SOUL_SAND || blockBelowState.getBlock() == MNDBlocks.RESURGENT_SOIL.get() || blockBelowState.getBlock() == MNDBlocks.RESURGENT_SOIL_FARMLAND.get();
            }
            if (!(block instanceof WitherRoseBlock) && !(block instanceof DoublePlantBlock)) {
                return blockBelowState.getBlock() == ModBlocks.RICH_SOIL.get() || blockBelowState.getBlock() == MNDBlocks.RESURGENT_SOIL.get();
            }
        }
        return false;
    }

    private void propagateBelowIfPossible(Block block, BlockPos position, ServerLevel level) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos newPos = position.offset(x, y, z);
                    if (!this.canBelowBlockSurvive(level, newPos)) continue;
                    validPositions.add(newPos);
                }
            }
        }
        if (!validPositions.isEmpty()) {
            boolean canPropagate;
            BlockPos plantPos = (BlockPos)validPositions.get(level.random.nextInt(validPositions.size()));
            BlockState targetState = level.getBlockState(plantPos);
            boolean bl = canPropagate = block instanceof LiquidBlockContainer && targetState.getBlock() == Blocks.WATER || !(block instanceof LiquidBlockContainer) && targetState.getBlock() == Blocks.AIR || block instanceof SimpleWaterloggedBlock && (targetState.getBlock() == Blocks.AIR || targetState.getBlock() == Blocks.WATER);
            if (canPropagate) {
                this.placeBlock(block, level, plantPos);
            }
        }
    }

    private boolean canBelowBlockSurvive(ServerLevel level, BlockPos newPos) {
        BlockState blockAboveState = level.getBlockState(newPos.above());
        return blockAboveState.getBlock() == ModBlocks.RICH_SOIL.get() || blockAboveState.getBlock() == MNDBlocks.RESURGENT_SOIL.get() || blockAboveState.getBlock() == ModBlocks.RICH_SOIL_FARMLAND.get() || blockAboveState.getBlock() == MNDBlocks.RESURGENT_SOIL_FARMLAND.get();
    }

    private void placeBlock(Block block, ServerLevel level, BlockPos pos) {
        BlockState state = block.defaultBlockState();
        if (block instanceof SimpleWaterloggedBlock) {
            FluidState fluidState = level.getFluidState(pos);
            state = fluidState.getType() == Fluids.WATER ? (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)) : (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        if (block instanceof PinkPetalsBlock) {
            Random random = new Random();
            Direction[] allowedDirections = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
            Direction randomDirection = allowedDirections[random.nextInt(allowedDirections.length)];
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PinkPetalsBlock.FACING, (Comparable)randomDirection));
        } else if (block instanceof DoublePlantBlock) {
            DoublePlantBlock.placeAt((LevelAccessor)level, (BlockState)state, (BlockPos)pos, (int)3);
        } else {
            level.setBlockAndUpdate(pos, state);
        }
        for (int i = 0; i < 3; ++i) {
            double d0 = (double)pos.getX() + level.getRandom().nextDouble();
            double d1 = (double)pos.getY() + level.getRandom().nextDouble();
            double d2 = (double)pos.getZ() + level.getRandom().nextDouble();
            level.sendParticles((ParticleOptions)ParticleTypes.SOUL, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
            level.playSound(null, pos, (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility toolAction, boolean simulate) {
        if (toolAction.equals(ItemAbilities.HOE_TILL) && context.getLevel().getBlockState(context.getClickedPos().above()).isAir()) {
            return MNDBlocks.RESURGENT_SOIL_FARMLAND.get().defaultBlockState();
        }
        return null;
    }

    public TriState canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, BlockState plantState) {
        if (plantState.getBlock() instanceof NetherWartBlock) {
            return TriState.TRUE;
        }
        if (plantState.is(MNDTags.RESURGENT_SOIL_PLANT) && !(plantState.getBlock() instanceof CropBlock) && !plantState.is(BlockTags.CROPS)) {
            return TriState.TRUE;
        }
        return TriState.DEFAULT;
    }
}

