/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.attachment.builder;

import fuzs.puzzleslib.api.attachment.v4.DataAttachmentType;
import fuzs.puzzleslib.impl.attachment.DataAttachmentTypeImpl;
import fuzs.puzzleslib.impl.attachment.builder.DataAttachmentBuilder;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import fuzs.puzzleslib.neoforge.impl.attachment.NeoForgeAttachmentTypeAdapter;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public class NeoForgeDataAttachmentBuilder<T extends IAttachmentHolder, V>
extends DataAttachmentBuilder<T, V> {
    @Override
    public DataAttachmentType<T, V> build(ResourceLocation resourceLocation) {
        DeferredRegister registrar = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)resourceLocation.getNamespace());
        NeoForgeModContainerHelper.getOptionalModEventBus(resourceLocation.getNamespace()).ifPresent(arg_0 -> ((DeferredRegister)registrar).register(arg_0));
        DeferredHolder attachmentType = registrar.register(resourceLocation.getPath(), () -> {
            AttachmentType.Builder builder = AttachmentType.builder(() -> {
                throw new UnsupportedOperationException("Attachment type " + String.valueOf(resourceLocation) + " does not support a default value!");
            });
            this.configureBuilder(builder);
            return builder.build();
        });
        NeoForgeAttachmentTypeAdapter adapter = new NeoForgeAttachmentTypeAdapter(attachmentType);
        BiConsumer synchronizer = this.getSynchronizer(resourceLocation, adapter);
        return new DataAttachmentTypeImpl(adapter, this.defaultValues, synchronizer);
    }

    @MustBeInvokedByOverriders
    void configureBuilder(AttachmentType.Builder<V> builder) {
        if (this.codec != null) {
            builder.serialize(this.codec).copyHandler((value, holder, registries) -> value);
        }
    }
}

