/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.accelerateddecay;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.utils.value.IntValue;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class AcceleratedDecay {
    public static final String MOD_ID = "accelerateddecay";
    private static final ConcurrentHashMap<TimedDimBlockPos, Boolean> timeBasedScanLocations = new ConcurrentHashMap();
    private static final BlockPos[] SCAN_LOCATIONS;

    public static void init() {
        BlockEvent.BREAK.register(AcceleratedDecay::breakHandler);
        TickEvent.SERVER_LEVEL_POST.register(AcceleratedDecay::levelTick);
    }

    private static void levelTick(ServerLevel serverLevel) {
        Instant now = Instant.now();
        Iterator iterator = ((ConcurrentHashMap.KeySetView)timeBasedScanLocations.keySet()).iterator();
        while (iterator.hasNext()) {
            TimedDimBlockPos location = (TimedDimBlockPos)iterator.next();
            if (location.checkAfter.isAfter(now) || !serverLevel.dimension().equals(location.dim)) continue;
            if (location.player == null || !location.player.isAlive()) {
                iterator.remove();
                continue;
            }
            Set<BlockPos> yeetLeaves = AcceleratedDecay.seekLeaves((Level)serverLevel, location.pos);
            boolean isFirst = true;
            for (BlockPos yeetLeaf : yeetLeaves) {
                EventResult eventResult;
                BlockState blockState = serverLevel.getBlockState(yeetLeaf);
                if (!blockState.is(BlockTags.LEAVES) || (eventResult = ((BlockEvent.Break)BlockEvent.BREAK.invoker()).breakBlock((Level)serverLevel, yeetLeaf, blockState, location.player, null)).isFalse()) continue;
                AcceleratedDecay.destroyBlockWithOptionalSoundAndParticles((Level)serverLevel, yeetLeaf, true, 512, location.player, isFirst);
                isFirst = false;
            }
            iterator.remove();
        }
    }

    private static EventResult breakHandler(Level level, BlockPos blockPos, BlockState state, ServerPlayer player, @Nullable IntValue intValue) {
        if (!state.is(BlockTags.LOGS)) {
            return EventResult.pass();
        }
        timeBasedScanLocations.put(new TimedDimBlockPos(Instant.now().plus(1L, ChronoUnit.SECONDS), blockPos, (ResourceKey<Level>)level.dimension(), player), Boolean.TRUE);
        return EventResult.pass();
    }

    private static Set<BlockPos> seekLeaves(Level level, BlockPos pos) {
        HashSet<BlockPos> validLocations = new HashSet<BlockPos>();
        HashSet<BlockPos> walked = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> nextToScan = new ArrayDeque<BlockPos>(List.of(pos));
        while (!nextToScan.isEmpty()) {
            BlockPos currentLocation = (BlockPos)nextToScan.pop();
            for (BlockPos offset : SCAN_LOCATIONS) {
                BlockPos nextLocation = currentLocation.offset((Vec3i)offset);
                BlockState state = level.getBlockState(nextLocation);
                if (!(state.getBlock() instanceof LeavesBlock) || ((Boolean)state.getValue((Property)BlockStateProperties.PERSISTENT)).booleanValue() || (Integer)state.getValue((Property)BlockStateProperties.DISTANCE) != 7 || !validLocations.add(nextLocation) || !walked.add(nextLocation)) continue;
                nextToScan.add(nextLocation);
            }
        }
        return validLocations;
    }

    public static void destroyBlockWithOptionalSoundAndParticles(Level level, BlockPos blockPos, boolean bl, int i, ServerPlayer player, boolean soundAndParticles) {
        BlockState blockState = level.getBlockState(blockPos);
        if (blockState.isAir()) {
            return;
        }
        FluidState fluidState = level.getFluidState(blockPos);
        if (!(blockState.getBlock() instanceof BaseFireBlock) && soundAndParticles) {
            level.levelEvent(2001, blockPos, Block.getId((BlockState)blockState));
        }
        if (bl) {
            BlockEntity blockEntity = blockState.hasBlockEntity() ? level.getBlockEntity(blockPos) : null;
            Block.dropResources((BlockState)blockState, (Level)level, (BlockPos)blockPos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)ItemStack.EMPTY);
        }
        level.setBlock(blockPos, fluidState.createLegacyBlock(), 3, i);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, blockPos);
    }

    static {
        BoundingBox box = new BoundingBox(BlockPos.ZERO).inflatedBy(1);
        SCAN_LOCATIONS = (BlockPos[])BlockPos.betweenClosedStream((BoundingBox)box).map(BlockPos::immutable).filter(e -> !e.equals((Object)BlockPos.ZERO)).distinct().toArray(BlockPos[]::new);
    }

    record TimedDimBlockPos(Instant checkAfter, BlockPos pos, ResourceKey<Level> dim, ServerPlayer player) {
    }
}

