/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.foundation.recipe;

import com.oierbravo.mechanicals.foundation.data.CompatMods;
import com.oierbravo.mechanicals.foundation.recipe.AbstractMechanicalRecipe;
import com.oierbravo.mechanicals.foundation.recipe.AbstractMechanicalRecipeParams;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;

public abstract class AbstractMechanicalRecipeBuilder<R extends AbstractMechanicalRecipe<?, P>, P extends AbstractMechanicalRecipeParams, BRB extends AbstractMechanicalRecipeBuilder<R, P, ?>> {
    protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    protected P params;
    protected ResourceLocation id;

    public abstract R build();

    public abstract BRB create();

    public BRB withRequirement(IRecipeRequirement requirement) {
        ((AbstractMechanicalRecipeParams)this.params).recipeRequirements.add(requirement);
        return (BRB)this;
    }

    public BRB withRequirements(List<IRecipeRequirement> pRecipeRequirements) {
        ((AbstractMechanicalRecipeParams)this.params).recipeRequirements.addAll(pRecipeRequirements);
        return (BRB)this;
    }

    public BRB whenModLoaded(String modid) {
        return this.withCondition((ICondition)new ModLoadedCondition(modid));
    }

    public BRB whenModMissing(String modid) {
        return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
    }

    public BRB forCompat(CompatMods mod) {
        return this.withCondition((ICondition)new ModLoadedCondition(mod.getId()));
    }

    public BRB withCondition(ICondition condition) {
        ((AbstractMechanicalRecipeParams)this.params).conditions.add(condition);
        return (BRB)this;
    }

    public BRB withConditions(List<ICondition> conditions) {
        ((AbstractMechanicalRecipeParams)this.params).conditions.addAll(conditions);
        return (BRB)this;
    }

    public BRB withoutCreateFromNothing() {
        ((AbstractMechanicalRecipeParams)this.params).conditions.add((ICondition)new NotCondition((ICondition)new ModLoadedCondition("create_from_nothing")));
        return (BRB)this;
    }

    public BRB withId(ResourceLocation id) {
        this.id = id;
        return (BRB)this;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        Advancement.Builder advancement = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)resourceLocation)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)resourceLocation)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
        recipeOutput.accept(resourceLocation, this.build(), advancement.build(resourceLocation.withPrefix("recipes/")));
    }

    public void saveCompat(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        Advancement.Builder advancement = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)resourceLocation)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)resourceLocation)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
        String compatId = resourceLocation.getPath().split("/")[0] + "/compat/" + resourceLocation.getPath().split("/")[1];
        ResourceLocation compatResourceLocation = ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)compatId);
        recipeOutput.accept(compatResourceLocation, this.build(), advancement.build(resourceLocation.withPrefix("recipes/")));
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, this.id);
    }

    public void saveCompat(RecipeOutput recipeOutput) {
        this.saveCompat(recipeOutput, this.id);
    }

    public BRB with(Consumer<BRB> consummer) {
        consummer.accept(this);
        return (BRB)this;
    }
}

