/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.embedded.videosurface;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import org.watermedia.videolan4j.binding.internal.libvlc_display_callback_t;
import org.watermedia.videolan4j.binding.internal.libvlc_lock_callback_t;
import org.watermedia.videolan4j.binding.internal.libvlc_unlock_callback_t;
import org.watermedia.videolan4j.binding.internal.libvlc_video_cleanup_cb;
import org.watermedia.videolan4j.binding.internal.libvlc_video_format_cb;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.player.base.MediaPlayer;
import org.watermedia.videolan4j.player.embedded.videosurface.NativeBuffers;
import org.watermedia.videolan4j.player.embedded.videosurface.VideoSurface;
import org.watermedia.videolan4j.player.embedded.videosurface.VideoSurfaceAdapter;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferCleanupCallback;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferFormat;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferFormatCallback;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.RenderCallback;

public class CallbackVideoSurface
extends VideoSurface {
    private final libvlc_video_format_cb setup = new SetupCallback();
    private final libvlc_video_cleanup_cb cleanup = new CleanupCallback();
    private final libvlc_lock_callback_t lock = new LockCallback();
    private final libvlc_unlock_callback_t unlock = new UnlockCallback();
    private final libvlc_display_callback_t display = new DisplayCallback();
    private final BufferFormatCallback bufferFormatCallback;
    private final BufferCleanupCallback cleanupCallback;
    private final RenderCallback renderCallback;
    private final NativeBuffers nativeBuffers;
    private MediaPlayer mediaPlayer;
    private BufferFormat bufferFormat;

    public CallbackVideoSurface(BufferFormatCallback formatCallback, RenderCallback renderCallback, boolean lock, VideoSurfaceAdapter surfaceAdapter, BufferCleanupCallback cleanupCallback) {
        super(surfaceAdapter);
        this.bufferFormatCallback = formatCallback;
        this.renderCallback = renderCallback;
        this.nativeBuffers = new NativeBuffers(lock);
        this.cleanupCallback = cleanupCallback;
    }

    @Override
    public void attach(MediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
        LibVlc.libvlc_video_set_format_callbacks(mediaPlayer.mediaPlayerInstance(), this.setup, this.cleanup);
        LibVlc.libvlc_video_set_callbacks(mediaPlayer.mediaPlayerInstance(), this.lock, this.unlock, this.display, null);
    }

    private final class SetupCallback
    implements libvlc_video_format_cb {
        private SetupCallback() {
        }

        @Override
        public int format(PointerByReference opaque, PointerByReference chroma, IntByReference width, IntByReference height, PointerByReference pitches, PointerByReference lines) {
            CallbackVideoSurface.this.bufferFormat = CallbackVideoSurface.this.bufferFormatCallback.getBufferFormat(width.getValue(), height.getValue());
            this.applyBufferFormat(CallbackVideoSurface.this.bufferFormat, chroma, width, height, pitches, lines);
            int result = CallbackVideoSurface.this.nativeBuffers.allocate(CallbackVideoSurface.this.bufferFormat);
            CallbackVideoSurface.this.bufferFormatCallback.allocatedBuffers(CallbackVideoSurface.this.nativeBuffers.buffers());
            return result;
        }

        private void applyBufferFormat(BufferFormat bufferFormat, PointerByReference chroma, IntByReference width, IntByReference height, PointerByReference pitches, PointerByReference lines) {
            byte[] chromaBytes = bufferFormat.getChroma().canonical().getBytes();
            chroma.getPointer().write(0L, chromaBytes, 0, Math.min(chromaBytes.length, 4));
            width.setValue(bufferFormat.getWidth());
            height.setValue(bufferFormat.getHeight());
            int[] pitchValues = bufferFormat.getPitches();
            int[] lineValues = bufferFormat.getLines();
            pitches.getPointer().write(0L, pitchValues, 0, pitchValues.length);
            lines.getPointer().write(0L, lineValues, 0, lineValues.length);
        }
    }

    private final class CleanupCallback
    implements libvlc_video_cleanup_cb {
        private CleanupCallback() {
        }

        @Override
        public void cleanup(Pointer opaque) {
            CallbackVideoSurface.this.cleanupCallback.cleanupBuffers(CallbackVideoSurface.this.nativeBuffers.buffers());
            CallbackVideoSurface.this.nativeBuffers.free();
        }
    }

    private final class LockCallback
    implements libvlc_lock_callback_t {
        private LockCallback() {
        }

        @Override
        public Pointer lock(Pointer opaque, PointerByReference planes) {
            Pointer[] pointers = CallbackVideoSurface.this.nativeBuffers.pointers();
            if (CallbackVideoSurface.this.semaphore != null) {
                try {
                    CallbackVideoSurface.this.semaphore.acquire();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Thread was interrupted", e);
                }
            }
            planes.getPointer().write(0L, pointers, 0, pointers.length);
            CallbackVideoSurface.this.semaphore.release();
            return null;
        }
    }

    private final class UnlockCallback
    implements libvlc_unlock_callback_t {
        private UnlockCallback() {
        }

        @Override
        public void unlock(Pointer opaque, Pointer picture, Pointer plane) {
        }
    }

    private final class DisplayCallback
    implements libvlc_display_callback_t {
        private DisplayCallback() {
        }

        @Override
        public void display(Pointer opaque, Pointer picture) {
            CallbackVideoSurface.this.renderCallback.display(CallbackVideoSurface.this.mediaPlayer, CallbackVideoSurface.this.nativeBuffers.buffers(), CallbackVideoSurface.this.bufferFormat);
        }
    }
}

