/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.discovery.providers;

import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.videolan4j.VideoLan4J;
import org.watermedia.videolan4j.discovery.NativeDiscovery;
import org.watermedia.videolan4j.discovery.providers.IProvider;

public class UserProvider
implements IProvider {
    private static final Marker IT;
    private static final File USER_DISCOVERY_PATH;

    @Override
    public boolean supported() {
        return USER_DISCOVERY_PATH != null && USER_DISCOVERY_PATH.exists();
    }

    @Override
    public IProvider.Priority priority() {
        return IProvider.Priority.HIGH;
    }

    @Override
    public String[] directories() {
        return new String[]{USER_DISCOVERY_PATH.getAbsolutePath()};
    }

    static {
        String decodedPath;
        IT = MarkerManager.getMarker((String)NativeDiscovery.class.getSimpleName());
        try {
            if (VideoLan4J.VLC4J_USER_DISCOVERY_PATH == null) {
                throw new NullPointerException();
            }
            decodedPath = URLDecoder.decode(VideoLan4J.VLC4J_USER_DISCOVERY_PATH, StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            VideoLan4J.LOGGER.debug(IT, "Cannot decode custom user path", (Throwable)e);
            decodedPath = null;
        }
        USER_DISCOVERY_PATH = decodedPath == null ? null : new File(decodedPath);
    }
}

