/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.WaterMedia;
import org.watermedia.api.WaterInternalAPI;
import org.watermedia.api.WaterMediaAPI;
import org.watermedia.core.tools.DataTool;
import org.watermedia.loaders.ILoader;

public class CacheAPI
extends WaterInternalAPI {
    private static final Marker IT = MarkerManager.getMarker((String)CacheAPI.class.getSimpleName());
    private static final Map<URI, Entry> ENTRIES = new HashMap<URI, Entry>();
    private static File dir;
    private static File index;
    private static boolean init;

    private static boolean refreshAll() {
        boolean bl;
        DataOutputStream out = new DataOutputStream(new GZIPOutputStream(Files.newOutputStream(index.toPath(), new OpenOption[0])));
        try {
            out.writeInt(ENTRIES.size());
            for (Map.Entry<URI, Entry> mapEntry : ENTRIES.entrySet()) {
                Entry entry = mapEntry.getValue();
                out.writeUTF(entry.getUri().toString());
                out.writeUTF(entry.getTag() == null ? "" : entry.getTag());
                out.writeLong(entry.getTime());
                out.writeLong(entry.getExpireTime());
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                WaterMedia.LOGGER.error(IT, "Failed to refresh cache index", (Throwable)e);
                return false;
            }
        }
        out.close();
        return bl;
    }

    private static File entry$getFile(URI url) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return new File(dir, DataTool.encodeHexString(digest.digest(url.toString().getBytes(StandardCharsets.UTF_8))));
        }
        catch (NoSuchAlgorithmException e) {
            WaterMedia.LOGGER.error(IT, "Failed to initalize digest", (Throwable)e);
            return new File(dir, Base64.getEncoder().encodeToString(url.toString().getBytes()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(URI url, String tag, long time, long expireTime, byte[] data) {
        Map<URI, Entry> map = ENTRIES;
        synchronized (map) {
            Entry entry = new Entry(url, tag, time, expireTime);
            boolean saved = false;
            File file = CacheAPI.entry$getFile(entry.uri);
            try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                out.write(data);
                saved = true;
            }
            catch (Exception e) {
                WaterMedia.LOGGER.error(IT, "Failed to save cache file {}", (Object)url, (Object)e);
            }
            if (saved && CacheAPI.refreshAll()) {
                ENTRIES.put(url, entry);
            } else if (file.exists() && file.delete()) {
                WaterMedia.LOGGER.warn(IT, "Cannot delete unsaved entry file of '{}' located in '{}'", (Object)url, (Object)file.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Entry getEntry(URI url) {
        Map<URI, Entry> map = ENTRIES;
        synchronized (map) {
            return ENTRIES.get(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateEntry(Entry fresh) {
        Map<URI, Entry> map = ENTRIES;
        synchronized (map) {
            ENTRIES.put(fresh.uri, fresh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteEntry(URI url) {
        Map<URI, Entry> map = ENTRIES;
        synchronized (map) {
            ENTRIES.remove(url);
            File file = CacheAPI.entry$getFile(url);
            if (file.exists() && file.delete()) {
                WaterMedia.LOGGER.warn(IT, "Cannot delete entry file of '{}' located in '{}'", (Object)url, (Object)file.toString());
            }
        }
    }

    @Override
    public WaterMediaAPI.Priority priority() {
        return WaterMediaAPI.Priority.HIGHEST;
    }

    @Override
    public boolean prepare(ILoader bootCore) throws Exception {
        dir = bootCore.tempDir().toAbsolutePath().resolve("cache/pictures").toFile();
        index = new File(dir, "index");
        WaterMedia.LOGGER.info(IT, "Mounted on path '{}'", (Object)dir);
        return !init;
    }

    @Override
    public void start(ILoader bootCore) throws Exception {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Cannot make necessary dirs for proper storing");
        }
        if (index.exists()) {
            try (DataInputStream stream = new DataInputStream(new GZIPInputStream(Files.newInputStream(index.toPath(), new OpenOption[0])));){
                int length = stream.readInt();
                for (int i = 0; i < length; ++i) {
                    String uri = stream.readUTF();
                    String tag = stream.readUTF();
                    long time = stream.readLong();
                    long expireTime = stream.readLong();
                    Entry entry = new Entry(new URI(uri), !tag.isEmpty() ? tag : null, time, expireTime);
                    ENTRIES.put(entry.getUri(), entry);
                }
            }
            catch (Exception e) {
                WaterMedia.LOGGER.error(IT, "Failed to load indexes", (Throwable)e);
            }
        }
        init = true;
    }

    @Override
    public void release() {
        CacheAPI.refreshAll();
    }

    static {
        init = false;
    }

    public static final class Entry {
        private final URI uri;
        private String tag;
        private long time;
        private long expireTime;

        public Entry(URI uri, String tag, long time, long expireTime) {
            this.uri = uri;
            this.tag = tag;
            this.time = time;
            this.expireTime = expireTime;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void setExpireTime(long expireTime) {
            this.expireTime = expireTime;
        }

        public URI getUri() {
            return this.uri;
        }

        public String getTag() {
            return this.tag;
        }

        public long getTime() {
            return this.time;
        }

        public long getExpireTime() {
            return this.expireTime;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expireTime;
        }

        public File getFile() {
            return CacheAPI.entry$getFile(this.uri);
        }
    }
}

