/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.content.contraptions.components.sifter.recipe;

import com.oierbravo.createsifter.content.contraptions.components.sifter.AbstractSifterBlockEntity;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipe;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipeBuilder;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipeInput;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class SiftingRecipeManager {
    public static Optional<SiftingRecipe> getRecipeForSifter(AbstractSifterBlockEntity sifter) {
        List<RecipeHolder<SiftingRecipe>> ingredientMatchingRecipes = SiftingRecipeManager.getRecipesMatchingIngredients(SiftingRecipeInput.fromSifter(sifter), sifter.getLevel());
        List<RecipeHolder> matchingRecipes = ingredientMatchingRecipes.stream().filter(siftingRecipeRecipeHolder -> ((SiftingRecipe)siftingRecipeRecipeHolder.value()).isWaterlogged() == sifter.isWaterlogged()).toList();
        if (matchingRecipes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SiftingRecipeManager.mergeRecipes(matchingRecipes.stream().map(RecipeHolder::value).toList()));
    }

    public static Optional<SiftingRecipe> getRecipeForHandSifting(Level level, SiftingRecipeInput input, boolean waterlogged) {
        List<RecipeHolder<SiftingRecipe>> ingredientMatchingRecipes = SiftingRecipeManager.getRecipesMatchingIngredients(input, level);
        List<RecipeHolder> matchingRecipes = ingredientMatchingRecipes.stream().filter(siftingRecipeRecipeHolder -> ((SiftingRecipe)siftingRecipeRecipeHolder.value()).isWaterlogged() == waterlogged).toList();
        if (matchingRecipes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SiftingRecipeManager.mergeRecipes(matchingRecipes.stream().map(RecipeHolder::value).toList()));
    }

    public static List<RecipeHolder<SiftingRecipe>> getRecipesMatchingIngredients(SiftingRecipeInput input, Level level) {
        assert (level != null);
        return level.getRecipeManager().getRecipesFor((RecipeType)SiftingRecipe.Type.INSTANCE, (RecipeInput)input, level);
    }

    public static SiftingRecipe mergeRecipes(List<SiftingRecipe> siftingRecipes) {
        SiftingRecipeBuilder builder = new SiftingRecipeBuilder();
        for (SiftingRecipe siftingRecipeHolder : siftingRecipes) {
            builder.require(siftingRecipeHolder.getInput()).requiredMesh(siftingRecipeHolder.getMesh()).output((List<ProcessingOutput>)siftingRecipeHolder.getResults()).processingTime(siftingRecipeHolder.getProcessingTime()).waterlogged(siftingRecipeHolder.isWaterlogged()).requiresAdvancedSifter(siftingRecipeHolder.advancedSifter());
            for (IRecipeRequirement recipeRequirement : siftingRecipeHolder.getRecipeRequirements()) {
                if (builder.hasRequirement(recipeRequirement.getType())) continue;
                builder.withRequirement(recipeRequirement);
            }
        }
        return builder.build();
    }

    public static List<RecipeHolder<SiftingRecipe>> getAllHolders() {
        return Objects.requireNonNull(Minecraft.getInstance().getConnection()).getRecipeManager().getAllRecipesFor((RecipeType)SiftingRecipe.Type.INSTANCE);
    }
}

