/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.content.contraptions.components.sifter.recipe;

import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipe;
import com.oierbravo.mechanicals.foundation.data.CompatMods;
import com.oierbravo.mechanicals.foundation.recipe.AbstractMechanicalRecipeBuilder;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.oierbravo.mechanicals.foundation.recipe.RecipeRequirementType;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.data.SimpleDatagenIngredient;
import com.simibubi.create.foundation.data.recipe.Mods;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class SiftingRecipeBuilder
extends AbstractMechanicalRecipeBuilder<SiftingRecipe, SiftingRecipe.SiftingRecipeParams, SiftingRecipeBuilder> {
    public SiftingRecipeBuilder create() {
        this.params = new SiftingRecipe.SiftingRecipeParams();
        return this;
    }

    public SiftingRecipeBuilder() {
        this.params = new SiftingRecipe.SiftingRecipeParams();
    }

    public SiftingRecipeBuilder require(Ingredient ingredient) {
        ((SiftingRecipe.SiftingRecipeParams)this.params).input = ingredient;
        return this;
    }

    public SiftingRecipeBuilder require(Block block) {
        return this.require((ItemLike)block.asItem());
    }

    public SiftingRecipeBuilder require(ItemLike item) {
        return this.require(Ingredient.of((ItemLike[])new ItemLike[]{item.asItem()}));
    }

    public SiftingRecipeBuilder require(ItemStack item) {
        return this.require(Ingredient.of((ItemStack[])new ItemStack[]{item}));
    }

    public SiftingRecipeBuilder require(Mods mod, String id) {
        return this.require(new SimpleDatagenIngredient(mod, id).toVanilla());
    }

    public SiftingRecipeBuilder require(ResourceLocation resourceLocation) {
        Item item = (Item)BuiltInRegistries.ITEM.get(resourceLocation);
        return this.require((ItemLike)item);
    }

    public SiftingRecipeBuilder require(TagKey<Item> tag) {
        return this.require(Ingredient.of(tag));
    }

    public SiftingRecipeBuilder output(ItemLike item) {
        return this.output(item, 1);
    }

    public SiftingRecipeBuilder output(float chance, ItemLike item) {
        return this.output(chance, item, 1);
    }

    public SiftingRecipeBuilder output(ItemLike item, int amount) {
        return this.output(1.0f, item, amount);
    }

    public SiftingRecipeBuilder output(float chance, ItemLike item, int amount) {
        return this.output(chance, new ItemStack(item, amount));
    }

    public SiftingRecipeBuilder output(ItemStack output) {
        return this.output(1.0f, output);
    }

    public SiftingRecipeBuilder output(float chance, ItemStack output) {
        return this.output(new ProcessingOutput(output, chance));
    }

    public SiftingRecipeBuilder output(float chance, Mods mod, String id, int amount) {
        return this.output(new ProcessingOutput(mod.asResource(id), amount, chance));
    }

    public SiftingRecipeBuilder output(ResourceLocation id) {
        return this.output(1.0f, id, 1);
    }

    public SiftingRecipeBuilder output(CompatMods mod, String id) {
        return this.output(mod, id, 1.0f, 1);
    }

    public SiftingRecipeBuilder output(CompatMods mod, String id, float chance) {
        return this.output(mod, id, chance, 1);
    }

    public SiftingRecipeBuilder output(CompatMods mod, String id, float chance, int amount) {
        return this.output(chance, mod.asResource(id), amount);
    }

    public SiftingRecipeBuilder output(float chance, ResourceLocation registryName, int amount) {
        return this.output(new ProcessingOutput(registryName, amount, chance));
    }

    public SiftingRecipeBuilder output(ProcessingOutput output) {
        ((SiftingRecipe.SiftingRecipeParams)this.params).results.add((Object)output);
        return this;
    }

    public SiftingRecipeBuilder output(List<ProcessingOutput> outputs) {
        ((SiftingRecipe.SiftingRecipeParams)this.params).results.addAll(outputs);
        return this;
    }

    public SiftingRecipeBuilder requiredMesh(ItemStack mesh) {
        ((SiftingRecipe.SiftingRecipeParams)this.params).mesh = mesh;
        return this;
    }

    public SiftingRecipeBuilder requiredMesh(ItemLike item) {
        return this.requiredMesh(new ItemStack(item));
    }

    public SiftingRecipeBuilder processingTime(int processingTime) {
        ((SiftingRecipe.SiftingRecipeParams)this.params).processingTime = processingTime;
        return this;
    }

    public SiftingRecipeBuilder waterlogged(boolean waterlogged) {
        ((SiftingRecipe.SiftingRecipeParams)this.params).waterlogged = waterlogged;
        return this;
    }

    public SiftingRecipeBuilder isWaterlogged() {
        return this.waterlogged(true);
    }

    public SiftingRecipeBuilder requiresAdvancedSifter() {
        return this.requiresAdvancedSifter(true);
    }

    public SiftingRecipeBuilder requiresAdvancedSifter(boolean advancedSifter) {
        ((SiftingRecipe.SiftingRecipeParams)this.params).advancedSifter = advancedSifter;
        return this;
    }

    public SiftingRecipe build() {
        return new SiftingRecipe((SiftingRecipe.SiftingRecipeParams)this.params);
    }

    public boolean hasRequirement(RecipeRequirementType<?> type) {
        Optional<IRecipeRequirement> requirement = ((SiftingRecipe.SiftingRecipeParams)this.params).recipeRequirements.stream().filter(iRecipeRequirement -> iRecipeRequirement.getType() == type).findFirst();
        return requirement.isPresent();
    }
}

