/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.compat.jei.category;

import com.oierbravo.createsifter.ModConstants;
import com.oierbravo.createsifter.ModLang;
import com.oierbravo.createsifter.compat.jei.category.animations.AbstractAnimatedSifter;
import com.oierbravo.createsifter.compat.jei.category.animations.AnimatedBrassSifter;
import com.oierbravo.createsifter.compat.jei.category.animations.AnimatedSifter;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipe;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipeManager;
import com.oierbravo.createsifter.register.ModBlocks;
import com.oierbravo.mechanicals.compat.jei.RecipeRequirementRenderer;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeWithRequirements;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluids;

public class SiftingCategory
extends CreateRecipeCategory<SiftingRecipe> {
    public static final ResourceLocation UID = ModConstants.asResource("sifting");
    public static final RecipeType<SiftingRecipe> TYPE = new RecipeType(UID, SiftingRecipe.class);
    public static final CreateRecipeCategory.Info<SiftingRecipe> INFO = new CreateRecipeCategory.Info(TYPE, (Component)ModLang.translate("recipe.sifting", new Object[0]).component(), (IDrawable)new EmptyBackground(177, 120), (IDrawable)new ItemIcon(() -> new ItemStack((ItemLike)ModBlocks.SIFTER.asItem())), SiftingRecipeManager::getAllHolders, List.of(() -> ModBlocks.SIFTER.asStack(), () -> ModBlocks.BRASS_SIFTER.asStack()));

    public SiftingCategory(CreateRecipeCategory.Info<SiftingRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SiftingRecipe recipe, IFocusGroup focuses) {
        List<ProcessingOutput> results;
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 3).setBackground(SiftingCategory.getRenderedSlot(), -1, -1).addIngredients(recipe.getInput());
        if (!recipe.getMesh().isEmpty()) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 3, 18).setBackground(SiftingCategory.getRenderedSlot(), -1, -1).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{recipe.getMesh()}));
        }
        if (recipe.isWaterlogged()) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 3, 36).setBackground(SiftingCategory.getRenderedSlot(), -1, -1).addFluidStack(Fluids.WATER.getSource(), 1000L);
        }
        boolean single = (results = recipe.getRollableResults()).size() == 1;
        int i = 0;
        for (ProcessingOutput output : results) {
            int xOffset = i % 9 * 19;
            int yOffset = i / 9 * 19;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, single ? 45 : 4 + xOffset, 60 + yOffset).setBackground(SiftingCategory.getRenderedSlot((ProcessingOutput)output), -1, -1).addItemStack(output.getStack())).addRichTooltipCallback(SiftingCategory.addStochasticTooltip((ProcessingOutput)output));
            ++i;
        }
    }

    public void draw(SiftingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        List<ProcessingOutput> results = recipe.getRollableResults();
        boolean single = results.size() == 1;
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 20, 2);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 50, 32);
        this.drawSifter(graphics, recipe.requiresAdvancedSifter(), recipe.isWaterlogged());
        RecipeRequirementRenderer.drawRequirements((IRecipeWithRequirements)recipe, (GuiGraphics)graphics, (int)67, (int)4);
    }

    protected void drawSifter(GuiGraphics guiGraphics, boolean pAdvanced, boolean waterlogged) {
        int x = 25;
        int y = 27;
        AbstractAnimatedSifter sifter = pAdvanced ? new AnimatedBrassSifter() : new AnimatedSifter();
        sifter.waterlogged(waterlogged);
        sifter.draw(guiGraphics, x, y);
    }
}

