/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.compat.jei;

import com.google.common.collect.ArrayListMultimap;
import com.oierbravo.createsifter.ModConstants;
import com.oierbravo.createsifter.compat.jei.category.SiftingCategory;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipe;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipeBuilder;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipeManager;
import com.oierbravo.createsifter.register.ModRecipes;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;

@ParametersAreNonnullByDefault
@JeiPlugin
public class CreateSifterJEI
implements IModPlugin {
    private static final ResourceLocation ID = ModConstants.asResource("jei_plugin");

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        CreateRecipeCategory.Factory factory = SiftingCategory::new;
        CreateRecipeCategory category = factory.create(SiftingCategory.INFO);
        registration.addRecipeCategories(new IRecipeCategory[]{category});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<SiftingRecipe> recipes = CreateSifterJEI.getRecipesMerged();
        registration.addRecipes(SiftingCategory.TYPE, CreateSifterJEI.getRecipesMerged());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        SiftingCategory.INFO.catalysts().forEach(supplier -> registration.addRecipeCatalyst((ItemStack)supplier.get(), new RecipeType[]{SiftingCategory.TYPE}));
    }

    public static ArrayListMultimap<Ingredient, SiftingRecipe> getRecipesGroupedByIngredient() {
        ArrayListMultimap groupedRecipes = ArrayListMultimap.create();
        SiftingRecipeManager.getAllHolders().stream().map(RecipeHolder::value).forEach(siftingRecipe -> {
            ModRecipes.SiftingRecipeJEICacheKey key = new ModRecipes.SiftingRecipeJEICacheKey((SiftingRecipe)((Object)siftingRecipe));
            groupedRecipes.put((Object)siftingRecipe.getInput(), (Object)siftingRecipe);
        });
        return groupedRecipes;
    }

    public static List<SiftingRecipe> getRecipesMerged() {
        ArrayListMultimap<Ingredient, SiftingRecipe> groupedRecipes = CreateSifterJEI.getRecipesGroupedByIngredient();
        ArrayList<SiftingRecipe> mergedRecipes = new ArrayList<SiftingRecipe>(List.of());
        for (Ingredient key : groupedRecipes.keySet()) {
            ArrayListMultimap groupedMeshes = ArrayListMultimap.create();
            List recipes = groupedRecipes.get((Object)key);
            recipes.forEach(siftingRecipe -> groupedMeshes.put((Object)siftingRecipe.getMesh().getItem(), (Object)siftingRecipe));
            for (Item mesh : groupedMeshes.keySet()) {
                List<SiftingRecipe> waterloggedRecipes;
                List meshRecipes = groupedMeshes.get((Object)mesh);
                List<SiftingRecipe> baseRecipes = meshRecipes.stream().filter(SiftingRecipe::isNotWaterlogged).toList();
                if (!baseRecipes.isEmpty()) {
                    mergedRecipes.add(CreateSifterJEI.mergeJEIRecipes("merged", baseRecipes));
                }
                if ((waterloggedRecipes = meshRecipes.stream().filter(SiftingRecipe::isWaterlogged).toList()).isEmpty()) continue;
                mergedRecipes.add(CreateSifterJEI.mergeJEIRecipes("merged_waterlogged", waterloggedRecipes));
            }
        }
        return mergedRecipes;
    }

    public static SiftingRecipe mergeJEIRecipes(String id, List<SiftingRecipe> recipes) {
        if (recipes.isEmpty()) {
            return null;
        }
        SiftingRecipeManager.mergeRecipes(recipes);
        SiftingRecipeBuilder builder = new SiftingRecipeBuilder();
        recipes.forEach(siftingRecipe -> builder.output((List<ProcessingOutput>)siftingRecipe.getResults()).requiresAdvancedSifter(siftingRecipe.advancedSifter()).waterlogged(siftingRecipe.isWaterlogged()).requiredMesh(siftingRecipe.getMesh()).require(siftingRecipe.getInput()));
        return builder.build();
    }
}

