/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.fan;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import io.github.cotrin8672.cem.client.CustomRenderType;
import io.github.cotrin8672.cem.config.CemConfig;
import io.github.cotrin8672.cem.content.block.fan.EnchantableEncasedFanBlockEntity;
import io.github.cotrin8672.cem.util.BlockEntityExtensionKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014J,\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/github/cotrin8672/cem/content/block/fan/EnchantableEncasedFanRenderer;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntityRenderer;", "Lio/github/cotrin8672/cem/content/block/fan/EnchantableEncasedFanBlockEntity;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "renderSafe", "", "be", "partialTicks", "", "ms", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "light", "", "overlay", "renderOrigin", "consumer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "Companion", "createenchantablemachinery"})
public final class EnchantableEncasedFanRenderer
extends KineticBlockEntityRenderer<EnchantableEncasedFanBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockEntityRendererProvider.Context context;
    private static final RandomSource RANDOM = RandomSource.create();

    public EnchantableEncasedFanRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.context = context;
    }

    protected void renderSafe(@NotNull EnchantableEncasedFanBlockEntity be, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (((Boolean)CemConfig.Companion.getCONFIG().getRenderGlint().get()).booleanValue()) {
            SheetedDecalTextureGenerator consumer = new SheetedDecalTextureGenerator(buffer.getBuffer(CustomRenderType.Companion.getGLINT()), ms.last(), 0.007125f);
            this.context.getBlockRenderDispatcher().renderBatched(be.getBlockState(), be.getBlockPos(), (BlockAndTintGetter)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)be), ms, (VertexConsumer)consumer, true, RANDOM);
            this.renderOrigin(be, ms, buffer, (VertexConsumer)consumer);
        }
    }

    private final void renderOrigin(EnchantableEncasedFanBlockEntity be, PoseStack ms, MultiBufferSource buffer, VertexConsumer consumer) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)((LevelAccessor)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)be)))) {
            return;
        }
        Direction direction = (Direction)be.getBlockState().getValue((Property)BlockStateProperties.FACING);
        VertexConsumer vertexConsumer = consumer;
        if (vertexConsumer == null) {
            vertexConsumer = buffer.getBuffer(RenderType.cutoutMipped());
        }
        VertexConsumer vb = vertexConsumer;
        int lightBehind = LevelRenderer.getLightColor((BlockAndTintGetter)((BlockAndTintGetter)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)be)), (BlockPos)be.getBlockPos().relative(direction.getOpposite()));
        int lightInFront = LevelRenderer.getLightColor((BlockAndTintGetter)((BlockAndTintGetter)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)be)), (BlockPos)be.getBlockPos().relative(direction));
        SuperByteBuffer shaftHalf = CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)be.getBlockState(), (Direction)direction.getOpposite());
        SuperByteBuffer fanInner = CachedBuffers.partialFacing((PartialModel)AllPartialModels.ENCASED_FAN_INNER, (BlockState)be.getBlockState(), (Direction)direction.getOpposite());
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)((LevelAccessor)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)be)));
        float speed = be.getSpeed() * (float)5;
        if (speed > 0.0f) {
            speed = Mth.clamp((float)speed, (float)80.0f, (float)1280.0f);
        }
        if (speed < 0.0f) {
            speed = Mth.clamp((float)speed, (float)-1280.0f, (float)-80.0f);
        }
        float angle = time * speed * (float)3 / 10.0f % (float)360;
        angle = angle / 180.0f * (float)Math.PI;
        KineticBlockEntityRenderer.standardKineticRotationTransform((SuperByteBuffer)shaftHalf, (KineticBlockEntity)((KineticBlockEntity)be), (int)lightBehind).renderInto(ms, vb);
        KineticBlockEntityRenderer.kineticRotationTransform((SuperByteBuffer)fanInner, (KineticBlockEntity)((KineticBlockEntity)be), (Direction.Axis)direction.getAxis(), (float)angle, (int)lightInFront).renderInto(ms, vb);
    }

    static /* synthetic */ void renderOrigin$default(EnchantableEncasedFanRenderer enchantableEncasedFanRenderer, EnchantableEncasedFanBlockEntity enchantableEncasedFanBlockEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, VertexConsumer vertexConsumer, int n, Object object) {
        if ((n & 8) != 0) {
            vertexConsumer = null;
        }
        enchantableEncasedFanRenderer.renderOrigin(enchantableEncasedFanBlockEntity, poseStack, multiBufferSource, vertexConsumer);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/github/cotrin8672/cem/content/block/fan/EnchantableEncasedFanRenderer$Companion;", "", "<init>", "()V", "RANDOM", "Lnet/minecraft/util/RandomSource;", "kotlin.jvm.PlatformType", "Lnet/minecraft/util/RandomSource;", "createenchantablemachinery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

