/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.drill;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.content.kinetics.drill.DrillBlock;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.material.Materials;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.BakedModelBuilder;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0014R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0018\u0010\u000e\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0018\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/github/cotrin8672/cem/content/block/drill/EnchantableDrillActorVisual;", "Lcom/simibubi/create/content/contraptions/render/ActorVisual;", "visualizationContext", "Ldev/engine_room/flywheel/api/visualization/VisualizationContext;", "world", "Lnet/minecraft/world/level/BlockAndTintGetter;", "context", "Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;", "<init>", "(Ldev/engine_room/flywheel/api/visualization/VisualizationContext;Lnet/minecraft/world/level/BlockAndTintGetter;Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;)V", "drillHead", "Ldev/engine_room/flywheel/lib/instance/TransformedInstance;", "kotlin.jvm.PlatformType", "Ldev/engine_room/flywheel/lib/instance/TransformedInstance;", "enchantedDrillHead", "facing", "Lnet/minecraft/core/Direction;", "Lnet/minecraft/core/Direction;", "rotation", "", "previousRotation", "tick", "", "beginFrame", "getRotation", "_delete", "createenchantablemachinery"})
public final class EnchantableDrillActorVisual
extends ActorVisual {
    private final TransformedInstance drillHead;
    private final TransformedInstance enchantedDrillHead;
    private final Direction facing;
    private double rotation;
    private double previousRotation;

    public EnchantableDrillActorVisual(@NotNull VisualizationContext visualizationContext, @NotNull BlockAndTintGetter world, @NotNull MovementContext context) {
        Intrinsics.checkNotNullParameter((Object)visualizationContext, (String)"visualizationContext");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(visualizationContext, world, context);
        this.drillHead = (TransformedInstance)this.instancerProvider.instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.DRILL_HEAD)).createInstance();
        this.enchantedDrillHead = (TransformedInstance)this.instancerProvider.instancer(InstanceTypes.TRANSFORMED, (Model)new BakedModelBuilder(AllPartialModels.DRILL_HEAD.get()).materialFunc(EnchantableDrillActorVisual::enchantedDrillHead$lambda$0).build()).createInstance();
        this.facing = (Direction)context.state.getValue((Property)DrillBlock.FACING);
    }

    public void tick() {
        this.previousRotation = this.rotation;
        if (this.context.disabled || VecHelper.isVecPointingTowards((Vec3)this.context.relativeMotion, (Direction)this.facing.getOpposite())) {
            return;
        }
        float deg = this.context.getAnimationSpeed();
        this.rotation += (double)deg / 20.0;
        this.rotation %= 360.0;
    }

    public void beginFrame() {
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.drillHead.setIdentityTransform().translate((Vec3i)this.context.localPos)).center()).rotateToFace(this.facing.getOpposite())).rotateZDegrees((float)this.getRotation())).uncenter()).setChanged();
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.enchantedDrillHead.setIdentityTransform().translate((Vec3i)this.context.localPos)).center()).rotateToFace(this.facing.getOpposite())).rotateZDegrees((float)this.getRotation())).uncenter()).setChanged();
    }

    private final double getRotation() {
        return AngleHelper.angleLerp((double)AnimationTickHolder.getPartialTicks(), (double)this.previousRotation, (double)this.rotation);
    }

    protected void _delete() {
        this.drillHead.delete();
        this.enchantedDrillHead.delete();
    }

    private static final Material enchantedDrillHead$lambda$0(RenderType renderType, Boolean bl) {
        return Materials.GLINT;
    }
}

