/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.block.properties.ConnectedProperty;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StringyCobwebBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<ConnectedProperty> CONNECTED = EnumProperty.create((String)"connected", ConnectedProperty.class);
    protected static final VoxelShape SHAPE_X = Block.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape SHAPE_Z = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);

    public StringyCobwebBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(CONNECTED, (Comparable)((Object)ConnectedProperty.MIDDLE)));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, CONNECTED});
    }

    public VoxelShape getShape(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        switch ((Direction)p_220053_1_.getValue((Property)FACING)) {
            case EAST: 
            case WEST: {
                return SHAPE_X;
            }
        }
        return SHAPE_Z;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : stateIn;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos abovePos = pos.above();
        BlockPos nextStringPos = pos.relative(direction).above();
        BlockPos prevStringPos = pos.relative(direction.getOpposite()).below();
        BlockPos belowPos = pos.below();
        BlockState aboveState = level.getBlockState(abovePos);
        BlockState nextStringState = level.getBlockState(nextStringPos);
        BlockState prevStringState = level.getBlockState(prevStringPos);
        BlockState belowState = level.getBlockState(belowPos);
        return !(!aboveState.isFaceSturdy((BlockGetter)level, abovePos, Direction.DOWN) && nextStringState.getBlock() != BOPBlocks.STRINGY_COBWEB || !belowState.isFaceSturdy((BlockGetter)level, belowPos, Direction.UP) && prevStringState.getBlock() != BOPBlocks.STRINGY_COBWEB);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean p_55572_) {
        super.onRemove(state, level, pos, newState, p_55572_);
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos abovePos = pos.relative(direction).above();
        BlockPos belowPos = pos.relative(direction.getOpposite()).below();
        BlockState aboveState = level.getBlockState(abovePos);
        BlockState belowState = level.getBlockState(belowPos);
        if (aboveState.getBlock() == BOPBlocks.STRINGY_COBWEB) {
            level.destroyBlock(abovePos, false);
        }
        if (belowState.getBlock() == BOPBlocks.STRINGY_COBWEB) {
            level.destroyBlock(belowPos, false);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] adirection;
        BlockState blockstate = super.getStateForPlacement(context);
        Level LevelReader2 = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        for (Direction direction : adirection = context.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal() || !(blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)LevelReader2, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public void entityInside(BlockState p_58180_, Level p_58181_, BlockPos p_58182_, Entity p_58183_) {
        p_58183_.setDeltaMovement(p_58183_.getDeltaMovement().multiply(0.75, 1.0, 0.75));
    }
}

