/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.model.light.data;

import net.caffeinemc.mods.sodium.client.services.PlatformBlockAccess;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;

public abstract class LightDataAccess {
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    protected BlockAndTintGetter level;

    public int get(int x, int y, int z, Direction d1, Direction d2) {
        return this.get(x + d1.getStepX() + d2.getStepX(), y + d1.getStepY() + d2.getStepY(), z + d1.getStepZ() + d2.getStepZ());
    }

    public int get(int x, int y, int z, Direction dir) {
        return this.get(x + dir.getStepX(), y + dir.getStepY(), z + dir.getStepZ());
    }

    public int get(BlockPos pos, Direction dir) {
        return this.get(pos.getX(), pos.getY(), pos.getZ(), dir);
    }

    public int get(BlockPos pos) {
        return this.get(pos.getX(), pos.getY(), pos.getZ());
    }

    public abstract int get(int var1, int var2, int var3);

    protected int compute(int x, int y, int z) {
        int sl;
        int bl;
        BlockPos.MutableBlockPos pos = this.pos.set(x, y, z);
        BlockAndTintGetter level = this.level;
        BlockState state = level.getBlockState((BlockPos)pos);
        boolean em = state.emissiveRendering((BlockGetter)level, (BlockPos)pos);
        boolean op = state.isViewBlocking((BlockGetter)level, (BlockPos)pos) && state.getLightBlock((BlockGetter)level, (BlockPos)pos) != 0;
        boolean fo = state.isSolidRender((BlockGetter)level, (BlockPos)pos);
        boolean fc = state.isCollisionShapeFullBlock((BlockGetter)level, (BlockPos)pos);
        int lu = PlatformBlockAccess.getInstance().getLightEmission(state, level, (BlockPos)pos);
        if (fo && lu == 0) {
            bl = 0;
            sl = 0;
        } else if (em) {
            bl = level.getBrightness(LightLayer.BLOCK, (BlockPos)pos);
            sl = level.getBrightness(LightLayer.SKY, (BlockPos)pos);
        } else {
            int light = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockState)state, (BlockPos)pos);
            bl = LightTexture.block((int)light);
            sl = LightTexture.sky((int)light);
        }
        float ao = lu == 0 ? state.getShadeBrightness((BlockGetter)level, (BlockPos)pos) : 1.0f;
        return LightDataAccess.packFC(fc) | LightDataAccess.packFO(fo) | LightDataAccess.packOP(op) | LightDataAccess.packEM(em) | LightDataAccess.packAO(ao) | LightDataAccess.packLU(lu) | LightDataAccess.packSL(sl) | LightDataAccess.packBL(bl);
    }

    public static int packBL(int blockLight) {
        return blockLight & 0xF;
    }

    public static int unpackBL(int word) {
        return word & 0xF;
    }

    public static int packSL(int skyLight) {
        return (skyLight & 0xF) << 4;
    }

    public static int unpackSL(int word) {
        return word >>> 4 & 0xF;
    }

    public static int packLU(int luminance) {
        return (luminance & 0xF) << 8;
    }

    public static int unpackLU(int word) {
        return word >>> 8 & 0xF;
    }

    public static int packAO(float ao) {
        int aoi = (int)(ao * 4096.0f);
        return (aoi & 0xFFFF) << 12;
    }

    public static float unpackAO(int word) {
        int aoi = word >>> 12 & 0xFFFF;
        return (float)aoi * 2.4414062E-4f;
    }

    public static int packEM(boolean emissive) {
        return (emissive ? 1 : 0) << 28;
    }

    public static boolean unpackEM(int word) {
        return (word >>> 28 & 1) != 0;
    }

    public static int packOP(boolean opaque) {
        return (opaque ? 1 : 0) << 29;
    }

    public static boolean unpackOP(int word) {
        return (word >>> 29 & 1) != 0;
    }

    public static int packFO(boolean opaque) {
        return (opaque ? 1 : 0) << 30;
    }

    public static boolean unpackFO(int word) {
        return (word >>> 30 & 1) != 0;
    }

    public static int packFC(boolean fullCube) {
        return (fullCube ? 1 : 0) << 31;
    }

    public static boolean unpackFC(int word) {
        return (word >>> 31 & 1) != 0;
    }

    public static int getLightmap(int word) {
        return LightTexture.pack((int)Math.max(LightDataAccess.unpackBL(word), LightDataAccess.unpackLU(word)), (int)LightDataAccess.unpackSL(word));
    }

    public static int getEmissiveLightmap(int word) {
        if (LightDataAccess.unpackEM(word)) {
            return 0xF000F0;
        }
        return LightDataAccess.getLightmap(word);
    }

    public BlockAndTintGetter getLevel() {
        return this.level;
    }
}

