/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavendermd.feature;

import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

public class TranslationsFeature
implements MarkdownFeature {
    @Override
    public String name() {
        return "translations";
    }

    @Override
    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return true;
    }

    @Override
    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            if (!nibbler.tryConsume("%{")) {
                return false;
            }
            String content = nibbler.consumeEscapedString('}', false);
            if (content == null || !nibbler.tryConsume('%')) {
                return false;
            }
            tokens.add(new TranslationToken(content));
            return true;
        }, '%');
    }

    @Override
    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, translation, tokens) -> {
            Parser.Node result = Parser.Node.empty();
            class_2561.method_43471((String)translation.key).method_27658((style, content) -> {
                result.addChild(new Parser.FormattingNode(arg_0 -> ((class_2583)style).method_27702(arg_0)).addChild(new Parser.TextNode(content)));
                return Optional.empty();
            }, class_2583.field_24360);
            return result;
        }, (token, tokenListNibbler) -> {
            TranslationToken translation;
            return token instanceof TranslationToken ? (translation = (TranslationToken)token) : null;
        });
    }

    private static final class TranslationToken
    extends Lexer.Token {
        public final String key;

        public TranslationToken(String key) {
            super("%{" + key + "}%");
            this.key = key;
        }
    }
}

