/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavendermd;

import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.util.StringNibbler;
import it.unimi.dsi.fastutil.chars.Char2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class Lexer
implements MarkdownFeature.TokenRegistrar {
    private final Char2ObjectMap<List<LexFunction>> lexFunctions = new Char2ObjectLinkedOpenHashMap();

    public Lexer() {
        this.registerToken((StringNibbler nibbler, List<Token> tokens) -> {
            String newlines = nibbler.consumeUntilEndOr(c -> c != '\n');
            if (newlines.length() > 1) {
                tokens.add(new NewlineToken("\n".repeat(newlines.length() - 1), true));
            } else {
                tokens.add(new NewlineToken(" ", false));
            }
            return true;
        }, '\n');
        this.registerToken((StringNibbler nibbler, List<Token> tokens) -> {
            nibbler.skip();
            Character escaped = nibbler.next();
            if (escaped == null || !this.lexFunctions.containsKey(escaped.charValue())) {
                return false;
            }
            if (escaped.charValue() == '\n') {
                tokens.add(new NewlineToken("\n", false));
            } else {
                Lexer.appendText((List<Token>)tokens, escaped.charValue());
            }
            return true;
        }, '\\');
    }

    @Override
    public void registerToken(LexFunction lexer, char trigger) {
        ((List)this.lexFunctions.computeIfAbsent(trigger, character -> new ArrayList())).add(0, lexer);
    }

    public List<Token> lex(String input) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        StringNibbler nibbler = new StringNibbler(input.strip());
        while (nibbler.hasNext()) {
            char current = nibbler.peek();
            if (this.lexFunctions.containsKey(current)) {
                boolean matched = false;
                for (LexFunction function : (List)this.lexFunctions.get(current)) {
                    if (!nibbler.tryMatch($ -> function.lex(nibbler, tokens))) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                nibbler.skip();
                Lexer.appendText(tokens, String.valueOf(current));
                continue;
            }
            Lexer.appendText(tokens, nibbler.consumeUntilEndOr(arg_0 -> ((CharSet)this.lexFunctions.keySet()).contains(arg_0)));
        }
        return tokens;
    }

    private static void appendText(List<Token> tokens, String text) {
        Token token;
        if (!tokens.isEmpty() && (token = tokens.get(tokens.size() - 1)) instanceof TextToken) {
            TextToken textToken = (TextToken)token;
            textToken.append(text);
        } else {
            tokens.add(new TextToken(text));
        }
    }

    private static void appendText(List<Token> tokens, char text) {
        Token token;
        if (!tokens.isEmpty() && (token = tokens.get(tokens.size() - 1)) instanceof TextToken) {
            TextToken textToken = (TextToken)token;
            textToken.append(text);
        } else {
            tokens.add(new TextToken(String.valueOf(text)));
        }
    }

    @FunctionalInterface
    public static interface LexFunction {
        public boolean lex(StringNibbler var1, List<Token> var2);
    }

    public static final class TextToken
    extends Token {
        private final StringBuilder contentBuilder;
        private String contentCache = "";
        private boolean dirty = true;

        public TextToken(String content) {
            super("");
            this.contentBuilder = new StringBuilder(content);
        }

        public void append(String content) {
            this.contentBuilder.append(content);
            this.dirty = true;
        }

        public void append(char content) {
            this.contentBuilder.append(content);
            this.dirty = true;
        }

        @Override
        public String content() {
            if (this.dirty) {
                this.contentCache = this.contentBuilder.toString();
                this.dirty = false;
            }
            return this.contentCache;
        }
    }

    public static final class NewlineToken
    extends Token {
        private final boolean isBoundary;

        public NewlineToken(String content, boolean isBoundary) {
            super(content);
            this.isBoundary = isBoundary;
        }

        @Override
        public boolean isBoundary() {
            return this.isBoundary;
        }
    }

    public static abstract class Token {
        protected final String content;

        protected Token(String content) {
            this.content = content;
        }

        public String content() {
            return this.content;
        }

        public boolean isBoundary() {
            return false;
        }

        public static LexFunction lexFromChar(Supplier<Token> factory) {
            return (nibbler, tokens) -> {
                nibbler.skip();
                tokens.add((Token)factory.get());
                return true;
            };
        }
    }
}

