/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.tom.createores.Registration;
import com.tom.createores.block.IOBlock;
import com.tom.createores.block.KineticInputBlock;
import com.tom.createores.block.MultiblockBlock;
import com.tom.createores.util.IOBlockType;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public interface MultiblockPart
extends IWrenchable {
    public static NonNullUnaryOperator<BlockBehaviour.Properties> props() {
        return p -> p.strength(10.0f).dynamicShape().noOcclusion();
    }

    public static NonNullUnaryOperator<BlockBehaviour.Properties> propsGhost() {
        return MultiblockPart.props().andThen(p -> p.noLootTable().pushReaction(PushReaction.BLOCK));
    }

    public ItemInteractionResult onActivate(BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, BlockHitResult var6);

    public InteractionResult onActivate(BlockState var1, Level var2, BlockPos var3, Player var4, BlockHitResult var5);

    public ItemStack pickBlock(BlockGetter var1, BlockPos var2, BlockState var3);

    public static interface MultiblockMainPart
    extends MultiblockPart {
        public MultiblockPartType[][][] getMultiblockLayout();

        default public InteractionResult onWrenched(BlockState state, UseOnContext context) {
            return InteractionResult.PASS;
        }

        default public Vec3i getSize(Direction facing) {
            MultiblockPartType[][][] layout = this.getMultiblockLayout();
            int x = layout[0].length;
            int y = layout.length;
            int z = layout[0][0].length;
            return facing.getAxis() == Direction.Axis.Z ? new Vec3i(x, y, z) : new Vec3i(z, y, x);
        }

        public Vec3i getStart(Direction var1);

        default public MultiblockPartType getPartTypeAt(Direction facing, int x, int y, int z) {
            Vec3i size = this.getSize(facing);
            switch (facing) {
                case EAST: {
                    int t = x;
                    x = z;
                    z = size.getX() - t - 1;
                    break;
                }
                case NORTH: {
                    break;
                }
                case SOUTH: {
                    x = size.getX() - x - 1;
                    z = size.getZ() - z - 1;
                    break;
                }
                case WEST: {
                    int t = x;
                    x = size.getZ() - z - 1;
                    z = t;
                    break;
                }
                default: {
                    return null;
                }
            }
            MultiblockPartType[][][] layout = this.getMultiblockLayout();
            return layout[y][z][x];
        }

        default public Direction getGhostDirection(Direction facing, int xIn, int yIn, int zIn) {
            MultiblockPartType[][][] layout = this.getMultiblockLayout();
            for (int x = 0; x < layout[0][0].length; ++x) {
                for (int y = 0; y < layout.length; ++y) {
                    for (int z = 0; z < layout[0].length; ++z) {
                        if (layout[y][z][x] != MultiblockPartType.MAIN) continue;
                        if (y == yIn) {
                            if (x == xIn) {
                                if (z > zIn) {
                                    return Direction.SOUTH;
                                }
                                return Direction.NORTH;
                            }
                            if (x > xIn) {
                                return Direction.EAST;
                            }
                            return Direction.WEST;
                        }
                        if (y > yIn) {
                            return Direction.UP;
                        }
                        return Direction.DOWN;
                    }
                }
            }
            return null;
        }

        default public Direction getBlockRotation(Direction facing, MultiblockPartType part) {
            return facing;
        }

        public static enum MultiblockPartType {
            BLANK(() -> ((MultiblockBlock)Registration.GHOST_BLOCK.get()).defaultBlockState()),
            MAIN,
            KINETIC(f -> (BlockState)Registration.KINETIC_INPUT.getDefaultState().setValue((Property)KineticInputBlock.SHAFT_FACING, (Comparable)f)),
            ITEM_IN(IOBlockType.ITEM_IN),
            ITEM_OUT(IOBlockType.ITEM_OUT),
            FLUID_IN(IOBlockType.FLUID_IN),
            FLUID_OUT(IOBlockType.FLUID_OUT);

            private final Function<Direction, BlockState> stateSupplier;

            private MultiblockPartType() {
                this.stateSupplier = null;
            }

            private MultiblockPartType(Supplier<BlockState> place) {
                this.stateSupplier = __ -> (BlockState)place.get();
            }

            private MultiblockPartType(Function<Direction, BlockState> place) {
                this.stateSupplier = place;
            }

            private MultiblockPartType(IOBlockType type) {
                this(() -> (BlockState)((IOBlock)Registration.IO_BLOCK.get()).defaultBlockState().setValue(IOBlock.TYPE, (Comparable)((Object)type)));
            }

            public BlockState getBlockState(Direction facing) {
                return this.stateSupplier.apply(facing);
            }
        }
    }

    public static interface MultiblockGhostPart
    extends MultiblockPart {
        public static UseOnContext makeCtx(UseOnContext context, BlockPos pos) {
            return new UseOnContext(context.getLevel(), context.getPlayer(), context.getHand(), context.getItemInHand(), new BlockHitResult(new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), context.getClickedFace(), pos, false));
        }

        default public InteractionResult onWrenched(BlockState state, UseOnContext context) {
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            for (int i = 0; i < 5 && state.getBlock() instanceof MultiblockGhostPart; ++i) {
                Direction d = ((MultiblockGhostPart)state.getBlock()).getParentDir(state);
                pos = pos.relative(d, 1);
                state = level.getBlockState(pos);
            }
            if (state.getBlock() instanceof MultiblockPart) {
                MultiblockPart d = (MultiblockPart)state.getBlock();
                if (d instanceof MultiblockGhostPart) {
                    return InteractionResult.PASS;
                }
                return d.onWrenched(state, MultiblockGhostPart.makeCtx(context, pos));
            }
            return InteractionResult.PASS;
        }

        default public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            for (int i = 0; i < 5 && state.getBlock() instanceof MultiblockGhostPart; ++i) {
                Direction d = ((MultiblockGhostPart)state.getBlock()).getParentDir(state);
                pos = pos.relative(d, 1);
                state = level.getBlockState(pos);
            }
            if (state.getBlock() != this && state.getBlock() instanceof MultiblockPart) {
                MultiblockPart d = (MultiblockPart)state.getBlock();
                if (d instanceof MultiblockGhostPart) {
                    return InteractionResult.PASS;
                }
                return d.onSneakWrenched(state, MultiblockGhostPart.makeCtx(context, pos));
            }
            return InteractionResult.PASS;
        }

        public Direction getParentDir(BlockState var1);

        default public void destroyParent(Level level, BlockPos pos, BlockState state, Player pPlayer) {
            for (int i = 0; i < 5 && state.getBlock() instanceof MultiblockGhostPart; ++i) {
                Direction d = ((MultiblockGhostPart)state.getBlock()).getParentDir(state);
                pos = pos.relative(d, 1);
                state = level.getBlockState(pos);
            }
            if (state.getBlock() instanceof MultiblockPart && !(state.getBlock() instanceof MultiblockGhostPart)) {
                level.destroyBlock(pos, !pPlayer.isCreative());
            }
        }

        default public boolean hasParent(BlockState state, LevelReader level, BlockPos pos) {
            BlockState p = level.getBlockState(pos.relative(this.getParentDir(state), 1));
            return p.getBlock() instanceof MultiblockPart;
        }

        @Override
        default public ItemInteractionResult onActivate(BlockState state, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
            for (int i = 0; i < 5 && state.getBlock() instanceof MultiblockGhostPart; ++i) {
                Direction d = ((MultiblockGhostPart)state.getBlock()).getParentDir(state);
                pos = pos.relative(d, 1);
                state = level.getBlockState(pos);
            }
            if (state.getBlock() != this && state.getBlock() instanceof MultiblockPart) {
                MultiblockPart d = (MultiblockPart)state.getBlock();
                if (d instanceof MultiblockGhostPart) {
                    return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
                }
                return d.onActivate(state, level, pos, pPlayer, pHand, new BlockHitResult(new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), pHit.getDirection(), pos, false));
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }

        @Override
        default public InteractionResult onActivate(BlockState state, Level level, BlockPos pos, Player pPlayer, BlockHitResult pHit) {
            for (int i = 0; i < 5 && state.getBlock() instanceof MultiblockGhostPart; ++i) {
                Direction d = ((MultiblockGhostPart)state.getBlock()).getParentDir(state);
                pos = pos.relative(d, 1);
                state = level.getBlockState(pos);
            }
            if (state.getBlock() != this && state.getBlock() instanceof MultiblockPart) {
                MultiblockPart d = (MultiblockPart)state.getBlock();
                if (d instanceof MultiblockGhostPart) {
                    return InteractionResult.PASS;
                }
                return d.onActivate(state, level, pos, pPlayer, new BlockHitResult(new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), pHit.getDirection(), pos, false));
            }
            return InteractionResult.PASS;
        }

        @Override
        default public ItemStack pickBlock(BlockGetter level, BlockPos pos, BlockState state) {
            for (int i = 0; i < 5 && state.getBlock() instanceof MultiblockGhostPart; ++i) {
                Direction d = ((MultiblockGhostPart)state.getBlock()).getParentDir(state);
                pos = pos.relative(d, 1);
                state = level.getBlockState(pos);
            }
            if (state.getBlock() != this && state.getBlock() instanceof MultiblockPart) {
                MultiblockPart d = (MultiblockPart)state.getBlock();
                if (d instanceof MultiblockGhostPart) {
                    return ItemStack.EMPTY;
                }
                return d.pickBlock(level, pos, state);
            }
            return ItemStack.EMPTY;
        }
    }
}

