/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.handler;

import fuzs.armorstatues.init.ModRegistry;
import fuzs.armorstatues.proxy.Proxy;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.statuemenus.api.v1.helper.ArmorStandInteractHelper;
import fuzs.statuemenus.api.v1.world.entity.decoration.ArmorStandDataProvider;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ArmorStandInteractHandler {
    public static EventResultHolder<InteractionResult> onUseEntityAt(Player player, Level level, InteractionHand interactionHand, Entity target, Vec3 hitVector) {
        if (player.getAbilities().mayBuild && target.getType() == EntityType.ARMOR_STAND) {
            boolean clientsideOnly = level.isClientSide && !ModLoaderEnvironment.INSTANCE.isModPresentServerside("armorstatues");
            MenuType menuType = clientsideOnly ? null : (MenuType)ModRegistry.ARMOR_STAND_MENU_TYPE.value();
            EventResultHolder result = ArmorStandInteractHelper.tryOpenArmorStatueMenu((Player)player, (Level)level, (InteractionHand)interactionHand, (ArmorStand)((ArmorStand)target), (MenuType)menuType, (ArmorStandDataProvider)ModRegistry.ARMOR_STAND_DATA_PROVIDER);
            if (result.isInterrupt() && clientsideOnly) {
                Proxy.INSTANCE.openArmorStandScreen((ArmorStand)target, player);
                player.swing(interactionHand);
                return EventResultHolder.interrupt((Object)InteractionResult.FAIL);
            }
            return result;
        }
        return EventResultHolder.pass();
    }
}

