/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.mafglib.util;

import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.hash.HashCode;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class RuntimePackHelper
implements PackResources,
RepositorySource,
Pack.ResourcesSupplier,
CachedOutput {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Joiner PATH_JOINER = Joiner.on((String)"/");
    private final IModFile file;
    private final PackType type;
    private final Pack.Position position;
    private final PackMetadataSection metadata;
    private final PackLocationInfo info;
    private final PackOutput output;
    private final ExistingFileHelper existingFileHelper;
    private final Map<Path, IoSupplier<InputStream>> resources = new HashMap<Path, IoSupplier<InputStream>>();

    private RuntimePackHelper(String name, ModContainer modContainer, PackType type, Pack.Position position, Component title, Component description) {
        IModInfo modInfo = modContainer.getModInfo();
        String modId = modInfo.getModId();
        ResourceLocation packId = ResourceLocation.fromNamespaceAndPath((String)modId, (String)name);
        this.file = modInfo.getOwningFile().getFile();
        this.type = type;
        this.position = position;
        this.metadata = new PackMetadataSection(description, SharedConstants.getCurrentVersion().getPackVersion(type));
        this.info = new PackLocationInfo(packId.toString(), title, PackSource.BUILT_IN, Optional.empty());
        this.output = new PackOutput(this.file.findResource(new String[]{""}));
        this.existingFileHelper = new ExistingFileHelper(Set.of(), Set.of(), false, null, null);
        Optional logoFile = modInfo.getLogoFile();
        Optional modResources = ResourcePackLoader.getPackFor((String)modInfo.getModId());
        if (logoFile.isPresent() && modResources.isPresent()) {
            PackLocationInfo packInfo = new PackLocationInfo("mod/" + modId, (Component)Component.empty(), PackSource.BUILT_IN, Optional.empty());
            try (PackResources packResources = ((Pack.ResourcesSupplier)modResources.get()).openPrimary(packInfo);){
                IoSupplier logoResource = packResources.getRootResource(((String)logoFile.get()).split("[/\\\\]"));
                this.resources.put(this.file.findResource(new String[]{"pack.png"}), (IoSupplier<InputStream>)logoResource);
            }
        }
    }

    public static RuntimePackHelper simpleRuntimePack(ModContainer modContainer, PackType type) {
        String modId = modContainer.getModId();
        MutableComponent title = Component.translatable((String)("pack." + modId + ".runtime"));
        MutableComponent description = Component.translatable((String)("pack." + modId + ".runtime.description"));
        return new RuntimePackHelper("runtime", modContainer, type, Pack.Position.TOP, (Component)title, (Component)description);
    }

    public static RuntimePackHelper createRuntimePack(String name, ModContainer modContainer, PackType type, Pack.Position position, Component title, Component description) {
        return new RuntimePackHelper(name, modContainer, type, position, title, description);
    }

    public ExistingFileHelper getExistingFileHelper() {
        return this.existingFileHelper;
    }

    public PackOutput getPackOutput() {
        return this.output;
    }

    public void addDataProvider(DataProvider provider) {
        LOGGER.info("Starting provider [{}] for runtime resource [{}]", (Object)provider, (Object)this.info.id());
        Stopwatch stopwatch = Stopwatch.createStarted();
        provider.run((CachedOutput)this).join();
        LOGGER.info("{} finished after {} ms", (Object)provider, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public PackLocationInfo location() {
        return this.info;
    }

    public PackResources openPrimary(PackLocationInfo info) {
        return this;
    }

    public PackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
        return this;
    }

    public void loadPacks(Consumer<Pack> loader) {
        loader.accept(Pack.readMetaAndCreate((PackLocationInfo)this.info, (Pack.ResourcesSupplier)this, (PackType)this.type, (PackSelectionConfig)new PackSelectionConfig(true, this.position, false)));
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... pathName) {
        Path path = this.file.findResource(pathName);
        return this.resources.get(path);
    }

    @Nullable
    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation location) {
        Path path = this.file.findResource(new String[]{type.getDirectory(), location.getNamespace(), location.getPath()});
        return this.resources.get(path);
    }

    public void listResources(PackType type, String namespace, String directory, PackResources.ResourceOutput output) {
        if (this.type != type) {
            return;
        }
        Path namespacePath = this.file.findResource(new String[]{type.getDirectory(), namespace});
        Path directoryPath = namespacePath.resolve(directory);
        this.resources.forEach((path, resource) -> {
            if (path.startsWith(directoryPath)) {
                String file = PATH_JOINER.join((Iterable)namespacePath.relativize((Path)path));
                ResourceLocation location = ResourceLocation.tryBuild((String)namespace, (String)file);
                if (location == null) {
                    LOGGER.warn("Invalid path in pack: {}:{}, ignoring", (Object)namespace, (Object)file);
                } else {
                    output.accept((Object)location, resource);
                }
            }
        });
    }

    public Set<String> getNamespaces(PackType type) {
        Path directoryPath = this.file.findResource(new String[]{type.getDirectory()});
        return this.resources.keySet().stream().map(path -> directoryPath.relativize((Path)path).getName(0).toString()).distinct().filter(namespace -> {
            if (ResourceLocation.isValidNamespace((String)namespace)) {
                return true;
            }
            LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", namespace, (Object)this.info.id());
            return false;
        }).collect(Collectors.toSet());
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> deserializer) {
        if (deserializer == PackMetadataSection.TYPE) {
            return (T)this.metadata;
        }
        return null;
    }

    public void close() {
    }

    public void writeIfNeeded(Path filePath, byte[] data, HashCode hashCode) {
        this.resources.put(filePath, (IoSupplier<InputStream>)((IoSupplier)() -> new ByteArrayInputStream(data)));
    }
}

