/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.util.EntityUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.animal.WolfVariants;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffers;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class NbtEntityUtils {
    @Nullable
    public static EntityType<?> getEntityTypeFromNbt(@Nonnull CompoundTag nbt) {
        Holder entry;
        if (nbt.contains("id", 8) && (entry = (Holder)BuiltInRegistries.ENTITY_TYPE.getHolder(ResourceLocation.tryParse((String)nbt.getString("id"))).orElse(null)) != null && entry.isBound()) {
            return (EntityType)entry.value();
        }
        return null;
    }

    public CompoundTag setEntityTypeToNbt(EntityType<?> type, @Nullable CompoundTag nbtIn) {
        CompoundTag nbt = new CompoundTag();
        ResourceLocation id = EntityType.getKey(type);
        if (id != null) {
            if (nbtIn != null) {
                nbtIn.putString("id", id.toString());
                return nbtIn;
            }
            nbt.putString("id", id.toString());
        }
        return nbt;
    }

    @Nullable
    public static AttributeMap getAttributesFromNbt(@Nonnull CompoundTag nbt) {
        EntityType<?> type = NbtEntityUtils.getEntityTypeFromNbt(nbt);
        if (type != null && nbt.contains("attributes", 9)) {
            AttributeMap container = new AttributeMap(DefaultAttributes.getSupplier(type));
            container.load(nbt.getList("attributes", 10));
            return container;
        }
        return null;
    }

    public static double getAttributeBaseValueFromNbt(@Nonnull CompoundTag nbt, Holder<Attribute> attribute) {
        AttributeMap attributes = NbtEntityUtils.getAttributesFromNbt(nbt);
        if (attributes != null) {
            return attributes.getBaseValue(attribute);
        }
        return -1.0;
    }

    public static double getAttributeValueFromNbt(@Nonnull CompoundTag nbt, Holder<Attribute> attribute) {
        AttributeMap attributes = NbtEntityUtils.getAttributesFromNbt(nbt);
        if (attributes != null) {
            return attributes.getValue(attribute);
        }
        return -1.0;
    }

    public static Pair<Double, Double> getHealthFromNbt(@Nonnull CompoundTag nbt) {
        double maxHealth;
        double health = 0.0;
        if (nbt.contains("Health", 99)) {
            health = nbt.getFloat("Health");
        }
        if ((maxHealth = NbtEntityUtils.getAttributeValueFromNbt(nbt, (Holder<Attribute>)Attributes.MAX_HEALTH)) < 0.0) {
            maxHealth = 20.0;
        }
        return Pair.of((Object)health, (Object)maxHealth);
    }

    public static Pair<Double, Double> getSpeedAndJumpStrengthFromNbt(@Nonnull CompoundTag nbt) {
        AttributeMap container = NbtEntityUtils.getAttributesFromNbt(nbt);
        double moveSpeed = 0.0;
        double jumpStrength = 0.0;
        if (container != null) {
            moveSpeed = container.getValue(Attributes.MOVEMENT_SPEED);
            jumpStrength = container.getValue(Attributes.JUMP_STRENGTH);
        }
        return Pair.of((Object)moveSpeed, (Object)jumpStrength);
    }

    @Nullable
    public static UUID getUUIDFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.hasUUID("UUID")) {
            return nbt.getUUID("UUID");
        }
        return null;
    }

    @Nullable
    public static Component getCustomNameFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        if (nbt.contains("CustomName", 8)) {
            String string = nbt.getString("CustomName");
            try {
                return Component.Serializer.fromJson((String)string, (HolderLookup.Provider)registry);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static CompoundTag setCustomNameToNbt(@Nonnull Component name, @Nonnull RegistryAccess registry, @Nullable CompoundTag nbtIn) {
        CompoundTag nbt = new CompoundTag();
        try {
            if (nbtIn != null) {
                nbtIn.putString("CustomName", Component.Serializer.toJson((Component)name, (HolderLookup.Provider)registry));
                return nbtIn;
            }
            nbt.putString("CustomName", Component.Serializer.toJson((Component)name, (HolderLookup.Provider)registry));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nbt;
    }

    public static Map<Holder<MobEffect>, MobEffectInstance> getActiveStatusEffectsFromNbt(@Nonnull CompoundTag nbt) {
        HashMap statusEffects = Maps.newHashMap();
        if (nbt.contains("active_effects", 9)) {
            ListTag list = nbt.getList("active_effects", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag data = list.getCompound(i);
                MobEffectInstance instance = MobEffectInstance.load((CompoundTag)data);
                if (instance == null) continue;
                statusEffects.put(instance.getEffect(), instance);
            }
        }
        return statusEffects;
    }

    public static NonNullList<ItemStack> getHandItemsFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        NonNullList list = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        if (nbt.contains("HandItems", 9)) {
            ListTag nbtList = nbt.getList("HandItems", 10);
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, (Object)ItemStack.parseOptional((HolderLookup.Provider)registry, (CompoundTag)nbtList.getCompound(i)));
            }
        }
        return list;
    }

    public static NonNullList<ItemStack> getArmorItemsFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        NonNullList list = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
        if (nbt.contains("ArmorItems", 9)) {
            ListTag nbtList = nbt.getList("ArmorItems", 10);
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, (Object)ItemStack.parseOptional((HolderLookup.Provider)registry, (CompoundTag)nbtList.getCompound(i)));
            }
        }
        return list;
    }

    public static ItemStack getBodyArmorFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        if (nbt.contains("body_armor_item", 10)) {
            return ItemStack.parseOptional((HolderLookup.Provider)registry, (CompoundTag)nbt.getCompound("body_armor_item"));
        }
        return ItemStack.EMPTY;
    }

    public static Pair<UUID, ItemStack> getOwnerAndSaddle(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        UUID owner = Util.NIL_UUID;
        ItemStack saddle = ItemStack.EMPTY;
        if (nbt.hasUUID("Owner")) {
            owner = nbt.getUUID("Owner");
        }
        if (nbt.contains("SaddleItem", 10)) {
            saddle = ItemStack.parseOptional((HolderLookup.Provider)registry, (CompoundTag)nbt.getCompound("SaddleItem"));
        }
        return Pair.of((Object)owner, (Object)saddle);
    }

    public static Pair<Integer, Integer> getAgeFromNbt(@Nonnull CompoundTag nbt) {
        int breedingAge = 0;
        int forcedAge = 0;
        if (nbt.contains("Age")) {
            breedingAge = nbt.getInt("Age");
        }
        if (nbt.contains("ForcedAge")) {
            forcedAge = nbt.getInt("ForcedAge");
        }
        return Pair.of((Object)breedingAge, (Object)forcedAge);
    }

    @Nullable
    public static MerchantOffers getTradeOffersFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        Optional opt;
        if (nbt.contains("Offers") && (opt = MerchantOffers.CODEC.parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt.get("Offers")).resultOrPartial()).isPresent()) {
            return (MerchantOffers)opt.get();
        }
        return null;
    }

    @Nullable
    public static VillagerData getVillagerDataFromNbt(@Nonnull CompoundTag nbt) {
        Optional opt;
        if (nbt.contains("VillagerData", 10) && (opt = VillagerData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("VillagerData"))).resultOrPartial()).isPresent()) {
            return (VillagerData)opt.get();
        }
        return null;
    }

    public static Pair<Integer, UUID> getZombieConversionTimerFromNbt(@Nonnull CompoundTag nbt) {
        int timer = -1;
        UUID player = Util.NIL_UUID;
        if (nbt.contains("ConversionTime", 99)) {
            timer = nbt.getInt("ConversionTime");
        }
        if (nbt.hasUUID("ConversionPlayer")) {
            player = nbt.getUUID("ConversionPlayer");
        }
        return Pair.of((Object)timer, (Object)player);
    }

    public static Pair<Integer, Integer> getDrownedConversionTimerFromNbt(@Nonnull CompoundTag nbt) {
        int drowning = -1;
        int inWater = -1;
        if (nbt.contains("DrownedConversionTime", 99)) {
            drowning = nbt.getInt("DrownedConversionTime");
        }
        if (nbt.contains("InWaterTime", 3)) {
            inWater = nbt.getInt("InWaterTime");
        }
        return Pair.of((Object)drowning, (Object)inWater);
    }

    public static int getStrayConversionTimeFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("StrayConversionTime", 99)) {
            return nbt.getInt("StrayConversionTime");
        }
        return -1;
    }

    public static Holder.Reference<EntityType<?>> getEntityTypeEntry(ResourceLocation id, @Nonnull RegistryAccess registry) {
        try {
            return registry.registry(BuiltInRegistries.ENTITY_TYPE.key()).flatMap(optional -> optional.getHolder(id)).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static EntityUtils.FakeLeashData getLeashDataFromNbt(@Nonnull CompoundTag nbt) {
        Either either;
        EntityUtils.FakeLeashData data = null;
        if (nbt.contains("leash", 10)) {
            data = new EntityUtils.FakeLeashData(-1, null, (Either<UUID, BlockPos>)Either.left((Object)nbt.getCompound("leash").getUUID("UUID")));
        } else if (nbt.contains("leash", 11) && (either = (Either)NbtUtils.readBlockPos((CompoundTag)nbt, (String)"leash").map(Either::right).orElse(null)) != null) {
            return new EntityUtils.FakeLeashData(-1, null, (Either<UUID, BlockPos>)either);
        }
        return data;
    }

    public static Pair<Panda.Gene, Panda.Gene> getPandaGenesFromNbt(@Nonnull CompoundTag nbt) {
        Panda.Gene mainGene = null;
        Panda.Gene hiddenGene = null;
        if (nbt.contains("MainGene", 8)) {
            mainGene = Panda.Gene.byName((String)nbt.getString("MainGene"));
        }
        if (nbt.contains("HiddenGene", 8)) {
            hiddenGene = Panda.Gene.byName((String)nbt.getString("HiddenGene"));
        }
        return Pair.of((Object)mainGene, hiddenGene);
    }

    public static Pair<Direction, Direction> getItemFrameDirectionsFromNbt(@Nonnull CompoundTag nbt) {
        Direction facing = null;
        Direction rotation = null;
        if (nbt.contains("Facing", 1)) {
            facing = Direction.from3DDataValue((int)nbt.getByte("Facing"));
        }
        if (nbt.contains("ItemRotation", 1)) {
            rotation = Direction.from3DDataValue((int)nbt.getByte("ItemRotation"));
        }
        return Pair.of((Object)facing, rotation);
    }

    public static Pair<Direction, PaintingVariant> getPaintingDataFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        Direction facing = null;
        Holder variant = null;
        if (nbt.contains("facing", 1)) {
            facing = Direction.from2DDataValue((int)nbt.getByte("facing"));
        }
        if (nbt.contains("variant", 10)) {
            variant = Painting.VARIANT_CODEC.parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial().orElse(null);
        }
        return Pair.of((Object)facing, variant != null ? (PaintingVariant)variant.value() : null);
    }

    @Nullable
    public static Axolotl.Variant getAxolotlVariantFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("Variant", 3)) {
            return Axolotl.Variant.byId((int)nbt.getInt("Variant"));
        }
        return null;
    }

    public static Pair<ResourceKey<CatVariant>, DyeColor> getCatVariantFromNbt(@Nonnull CompoundTag nbt) {
        ResourceKey variantKey = null;
        DyeColor collar = null;
        if (nbt.contains("variant", 8) && (variantKey = ResourceKey.create((ResourceKey)Registries.CAT_VARIANT, (ResourceLocation)ResourceLocation.tryParse((String)nbt.getString("variant")))) == null) {
            variantKey = CatVariant.ALL_BLACK;
        }
        if (nbt.contains("CollarColor", 99)) {
            collar = DyeColor.byId((int)nbt.getInt("CollarColor"));
        }
        return Pair.of((Object)variantKey, collar);
    }

    @Nullable
    public static ResourceKey<FrogVariant> getFrogVariantFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("variant", 8)) {
            ResourceKey variantKey = ResourceKey.create((ResourceKey)Registries.FROG_VARIANT, (ResourceLocation)ResourceLocation.tryParse((String)nbt.getString("variant")));
            if (variantKey == null) {
                variantKey = FrogVariant.TEMPERATE;
            }
            return variantKey;
        }
        return null;
    }

    public static Pair<Variant, Markings> getHorseVariantFromNbt(@Nonnull CompoundTag nbt) {
        Variant color = null;
        Markings marking = null;
        if (nbt.contains("Variant", 3)) {
            int variant = nbt.getInt("Variant");
            color = Variant.byId((int)(variant & 0xFF));
            marking = Markings.byId((int)((variant & 0xFF00) >> 8));
        }
        return Pair.of(color, marking);
    }

    @Nullable
    public static Parrot.Variant getParrotVariantFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("Variant", 3)) {
            return Parrot.Variant.byId((int)nbt.getInt("Variant"));
        }
        return null;
    }

    @Nullable
    public static TropicalFish.Pattern getFishVariantFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("Variant", 3)) {
            return TropicalFish.Pattern.byId((int)(nbt.getInt("Variant") & 0xFFFF));
        }
        if (nbt.contains("BucketVariantTag", 3)) {
            return TropicalFish.Pattern.byId((int)(nbt.getInt("BucketVariantTag") & 0xFFFF));
        }
        return null;
    }

    public static Pair<ResourceKey<WolfVariant>, DyeColor> getWolfVariantFromNbt(@Nonnull CompoundTag nbt) {
        ResourceKey variantKey = null;
        DyeColor collar = null;
        if (nbt.contains("variant", 8)) {
            variantKey = ResourceKey.create((ResourceKey)Registries.WOLF_VARIANT, (ResourceLocation)ResourceLocation.tryParse((String)nbt.getString("variant")));
        }
        if (nbt.contains("CollarColor", 99)) {
            collar = DyeColor.byId((int)nbt.getInt("CollarColor"));
        }
        if (variantKey == null) {
            variantKey = WolfVariants.DEFAULT;
        }
        if (collar == null) {
            collar = DyeColor.RED;
        }
        return Pair.of((Object)variantKey, (Object)collar);
    }

    @Nullable
    public static DyeColor getSheepColorFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("Color", 1)) {
            return DyeColor.byId((int)nbt.getByte("Color"));
        }
        return null;
    }

    @Nullable
    public static Rabbit.Variant getRabbitTypeFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("RabbitType", 3)) {
            return Rabbit.Variant.byId((int)nbt.getInt("RabbitType"));
        }
        return null;
    }

    public static Pair<Llama.Variant, Integer> getLlamaTypeFromNbt(@Nonnull CompoundTag nbt) {
        Llama.Variant variant = null;
        int strength = -1;
        if (nbt.contains("Variant", 3)) {
            variant = Llama.Variant.byId((int)nbt.getInt("Variant"));
        }
        if (nbt.contains("Strength", 3)) {
            strength = nbt.getInt("Strength");
        }
        return Pair.of((Object)variant, (Object)strength);
    }

    @Nullable
    public static Fox.Type getFoxVariantFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("Type", 8)) {
            return Fox.Type.byName((String)nbt.getString("Type"));
        }
        return null;
    }

    public static Triple<BlockPos, Integer, Boolean> getDolphinDataFromNbt(@Nonnull CompoundTag nbt) {
        BlockPos treasure = BlockPos.ZERO;
        int moist = -1;
        boolean hasFish = false;
        if (nbt.contains("TreasurePosX", 3) && nbt.contains("TreasurePosY", 3) && nbt.contains("TreasurePosZ", 3)) {
            treasure = new BlockPos(nbt.getInt("TreasurePosX"), nbt.getInt("TreasurePosY"), nbt.getInt("TreasurePosZ"));
        }
        if (nbt.contains("Moistness", 3)) {
            moist = nbt.getInt("Moistness");
        }
        if (nbt.contains("GotFish")) {
            hasFish = nbt.getBoolean("GotFish");
        }
        return Triple.of((Object)treasure, (Object)moist, (Object)hasFish);
    }

    public static Triple<Integer, Integer, Float> getPlayerExpFromNbt(@Nonnull CompoundTag nbt) {
        int level = -1;
        int total = -1;
        float progress = 0.0f;
        if (nbt.contains("XpLevel", 3)) {
            level = nbt.getInt("XpLevel");
        }
        if (nbt.contains("XpTotal", 3)) {
            total = nbt.getInt("XpTotal");
        }
        if (nbt.contains("XpP", 5)) {
            progress = nbt.getFloat("XpP");
        }
        return Triple.of((Object)level, (Object)total, (Object)Float.valueOf(progress));
    }

    @Nullable
    public static FoodData getPlayerHungerFromNbt(@Nonnull CompoundTag nbt) {
        FoodData hunger = null;
        if (nbt.contains("foodLevel", 99)) {
            hunger = new FoodData();
            hunger.readAdditionalSaveData(nbt);
        }
        return hunger;
    }
}

