/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.game.wrap;

import java.util.Set;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class NbtWrap {
    public static boolean containsByte(CompoundTag tag, String name) {
        return NbtWrap.contains(tag, name, 1);
    }

    public static boolean containsShort(CompoundTag tag, String name) {
        return NbtWrap.contains(tag, name, 2);
    }

    public static boolean containsInt(CompoundTag tag, String name) {
        return NbtWrap.contains(tag, name, 3);
    }

    public static boolean containsLong(CompoundTag tag, String name) {
        return NbtWrap.contains(tag, name, 4);
    }

    public static boolean containsFloat(CompoundTag tag, String name) {
        return NbtWrap.contains(tag, name, 5);
    }

    public static boolean containsDouble(CompoundTag tag, String name) {
        return NbtWrap.contains(tag, name, 6);
    }

    public static boolean containsString(CompoundTag tag, String name) {
        return NbtWrap.contains(tag, name, 8);
    }

    public static boolean containsCompound(CompoundTag tag, String name) {
        return NbtWrap.contains(tag, name, 10);
    }

    public static boolean containsList(CompoundTag tag, String name) {
        return NbtWrap.contains(tag, name, 9);
    }

    public static boolean containsByteArray(CompoundTag tag, String name) {
        return NbtWrap.contains(tag, name, 7);
    }

    public static boolean containsIntArray(CompoundTag tag, String name) {
        return NbtWrap.contains(tag, name, 11);
    }

    public static boolean containsLongArray(CompoundTag tag, String name) {
        return NbtWrap.contains(tag, name, 12);
    }

    public static boolean contains(CompoundTag tag, String name, int typeId) {
        return tag.contains(name, typeId);
    }

    public static boolean hasUUID(CompoundTag tag) {
        return NbtWrap.hasUUID(tag, "UUIDM", "UUIDL");
    }

    public static boolean hasUUID(CompoundTag tag, String keyM, String keyL) {
        return NbtWrap.containsLong(tag, keyM) && NbtWrap.containsLong(tag, keyL);
    }

    public static boolean getBoolean(CompoundTag tag, String name) {
        return tag.getBoolean(name);
    }

    public static byte getByte(CompoundTag tag, String name) {
        return tag.getByte(name);
    }

    public static short getShort(CompoundTag tag, String name) {
        return tag.getShort(name);
    }

    public static int getInt(CompoundTag tag, String name) {
        return tag.getInt(name);
    }

    public static long getLong(CompoundTag tag, String name) {
        return tag.getLong(name);
    }

    public static float getFloat(CompoundTag tag, String name) {
        return tag.getFloat(name);
    }

    public static double getDouble(CompoundTag tag, String name) {
        return tag.getDouble(name);
    }

    public static String getString(CompoundTag tag, String name) {
        return tag.getString(name);
    }

    public static CompoundTag getCompound(CompoundTag tag, String name) {
        return tag.getCompound(name);
    }

    public static ListTag getList(CompoundTag tag, String name, int type) {
        return tag.getList(name, type);
    }

    public static byte[] getByteArray(CompoundTag tag, String name) {
        return tag.getByteArray(name);
    }

    public static int[] getIntArray(CompoundTag tag, String name) {
        return tag.getIntArray(name);
    }

    public static Tag getTag(CompoundTag tag, String name) {
        return tag.get(name);
    }

    public static boolean getBooleanOrDefault(CompoundTag tag, String name, boolean defaultValue) {
        return NbtWrap.containsByte(tag, name) ? NbtWrap.getByte(tag, name) != 0 : defaultValue;
    }

    public static byte getByteOrDefault(CompoundTag tag, String name, byte defaultValue) {
        return NbtWrap.containsByte(tag, name) ? NbtWrap.getByte(tag, name) : defaultValue;
    }

    public static short getShortOrDefault(CompoundTag tag, String name, short defaultValue) {
        return NbtWrap.containsShort(tag, name) ? NbtWrap.getShort(tag, name) : defaultValue;
    }

    public static int getIntOrDefault(CompoundTag tag, String name, int defaultValue) {
        return NbtWrap.containsInt(tag, name) ? NbtWrap.getInt(tag, name) : defaultValue;
    }

    public static long getLongOrDefault(CompoundTag tag, String name, long defaultValue) {
        return NbtWrap.containsLong(tag, name) ? NbtWrap.getLong(tag, name) : defaultValue;
    }

    public static float getFloatOrDefault(CompoundTag tag, String name, float defaultValue) {
        return NbtWrap.containsFloat(tag, name) ? NbtWrap.getFloat(tag, name) : defaultValue;
    }

    public static double getDoubleOrDefault(CompoundTag tag, String name, double defaultValue) {
        return NbtWrap.containsDouble(tag, name) ? NbtWrap.getDouble(tag, name) : defaultValue;
    }

    public static String getStringOrDefault(CompoundTag tag, String name, String defaultValue) {
        return NbtWrap.containsString(tag, name) ? NbtWrap.getString(tag, name) : defaultValue;
    }

    public static String getCommandFeedbackName(Tag tag) {
        return tag.getType().toString();
    }

    public static int getTypeId(Tag tag) {
        return tag.getId();
    }

    public static ByteTag asByteTag(byte value) {
        return ByteTag.valueOf((byte)value);
    }

    public static ShortTag asShortTag(short value) {
        return ShortTag.valueOf((short)value);
    }

    public static IntTag asIntTag(int value) {
        return IntTag.valueOf((int)value);
    }

    public static LongTag asLongTag(long value) {
        return LongTag.valueOf((long)value);
    }

    public static FloatTag asFloatTag(float value) {
        return FloatTag.valueOf((float)value);
    }

    public static DoubleTag asDoubleTag(double value) {
        return DoubleTag.valueOf((double)value);
    }

    public static StringTag asStringTag(String value) {
        return StringTag.valueOf((String)value);
    }

    public static void putBoolean(CompoundTag tag, String name, boolean value) {
        tag.putBoolean(name, value);
    }

    public static void putByte(CompoundTag tag, String name, byte value) {
        tag.putByte(name, value);
    }

    public static void putShort(CompoundTag tag, String name, short value) {
        tag.putShort(name, value);
    }

    public static void putInt(CompoundTag tag, String name, int value) {
        tag.putInt(name, value);
    }

    public static void putLong(CompoundTag tag, String name, long value) {
        tag.putLong(name, value);
    }

    public static void putFloat(CompoundTag tag, String name, float value) {
        tag.putFloat(name, value);
    }

    public static void putDouble(CompoundTag tag, String name, double value) {
        tag.putDouble(name, value);
    }

    public static void putString(CompoundTag tag, String name, String value) {
        tag.putString(name, value);
    }

    public static void putTag(CompoundTag tag, String name, Tag value) {
        tag.put(name, value);
    }

    public static void putByteArray(CompoundTag tag, String name, byte[] value) {
        tag.putByteArray(name, value);
    }

    public static void putIntArray(CompoundTag tag, String name, int[] value) {
        tag.putIntArray(name, value);
    }

    public static void remove(CompoundTag tag, String name) {
        tag.remove(name);
    }

    public static void addTag(ListTag listTag, Tag value) {
        listTag.add((Object)value);
    }

    public static Set<String> getKeys(CompoundTag tag) {
        return tag.getAllKeys();
    }

    public static int getListSize(ListTag list) {
        return list.size();
    }

    public static int getListStoredType(ListTag listTag) {
        return listTag.getElementType();
    }

    public static ListTag getListOfCompounds(CompoundTag tag, String name) {
        return NbtWrap.getList(tag, name, 10);
    }

    public static double getDoubleAt(ListTag listTag, int index) {
        return listTag.getDouble(index);
    }

    public static int getIntAt(ListTag listTag, int index) {
        return listTag.getInt(index);
    }

    public static CompoundTag getCompoundAt(ListTag listTag, int index) {
        return listTag.getCompound(index);
    }

    public static CompoundTag copy(CompoundTag tag) {
        return tag.copy();
    }

    public static ListTag copy(ListTag tag) {
        return tag.copy();
    }
}

