/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ItemType {
    private ItemStack stack;
    private final boolean checkNBT;

    public ItemType(ItemStack stack) {
        this(stack, true, true);
    }

    public ItemType(ItemStack stack, boolean copy, boolean checkNBT) {
        this.stack = stack.isEmpty() ? ItemStack.EMPTY : (copy ? stack.copy() : stack);
        this.checkNBT = checkNBT;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean checkNBT() {
        return this.checkNBT;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.stack.getItem().hashCode();
        if (this.checkNBT()) {
            result = 31 * result + (this.stack.getComponents() != null ? this.stack.getComponents().hashCode() : 0);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemType other = (ItemType)obj;
        if (this.stack.isEmpty() || other.stack.isEmpty()) {
            return this.stack.isEmpty() == other.stack.isEmpty();
        }
        if (this.stack.getItem() != other.stack.getItem()) {
            return false;
        }
        return !this.checkNBT() || Objects.equals(this.stack.getComponents(), other.stack.getComponents());
    }

    public String toString() {
        if (this.checkNBT()) {
            ResourceLocation rl = BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem());
            return String.valueOf(rl) + " " + String.valueOf(this.stack.getComponents());
        }
        return BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).toString();
    }
}

