/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test;

import com.mojang.blaze3d.vertex.BufferBuilder;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class TestUtils {
    public static void drawBlockBoundingBoxSidesBatchedQuads(BlockPos pos, Vec3 cameraPos, Color4f color, double expand, BufferBuilder buffer) {
        float minX = (float)((double)pos.getX() - cameraPos.x - expand);
        float minY = (float)((double)pos.getY() - cameraPos.y - expand);
        float minZ = (float)((double)pos.getZ() - cameraPos.z - expand);
        float maxX = (float)((double)pos.getX() - cameraPos.x + expand + 1.0);
        float maxY = (float)((double)pos.getY() - cameraPos.y + expand + 1.0);
        float maxZ = (float)((double)pos.getZ() - cameraPos.z + expand + 1.0);
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    protected static Pair<BlockPos, BlockPos> getSpawnChunkCorners(BlockPos worldSpawn, int chunkRange, Level world) {
        int cx = worldSpawn.getX() >> 4;
        int cz = worldSpawn.getZ() >> 4;
        int minY = TestUtils.getMinY(world);
        int maxY = world != null ? world.getMaxBuildHeight() : 320;
        BlockPos pos1 = new BlockPos(cx - chunkRange << 4, minY, cz - chunkRange << 4);
        BlockPos pos2 = new BlockPos((cx + chunkRange << 4) + 15, maxY, (cz + chunkRange << 4) + 15);
        return Pair.of((Object)pos1, (Object)pos2);
    }

    private static int getMinY(Level world) {
        Minecraft mc = Minecraft.getInstance();
        int minY = Minecraft.useShaderTransparency() && world != null && mc.player != null ? (mc.player.blockPosition().getY() >= world.getSeaLevel() ? world.getSeaLevel() - 2 : world.getMinBuildHeight()) : (world != null ? world.getMinBuildHeight() : -64);
        return minY;
    }

    public static void renderWallsWithLines(BlockPos posStart, BlockPos posEnd, Vec3 cameraPos, double lineIntervalH, double lineIntervalV, boolean alignLinesToModulo, Color4f color, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        double minZ;
        double maxZ;
        double maxX;
        double minX;
        Entity entity = EntityUtils.getCameraEntity();
        int boxMinX = Math.min(posStart.getX(), posEnd.getX());
        int boxMinZ = Math.min(posStart.getZ(), posEnd.getZ());
        int boxMaxX = Math.max(posStart.getX(), posEnd.getX());
        int boxMaxZ = Math.max(posStart.getZ(), posEnd.getZ());
        int centerX = (int)Math.floor(entity.getX());
        int centerZ = (int)Math.floor(entity.getZ());
        int maxDist = (Integer)Minecraft.getInstance().options.renderDistance().get() * 32;
        int rangeMinX = centerX - maxDist;
        int rangeMinZ = centerZ - maxDist;
        int rangeMaxX = centerX + maxDist;
        int rangeMaxZ = centerZ + maxDist;
        double minY = Math.min(posStart.getY(), posEnd.getY());
        double maxY = Math.max(posStart.getY(), posEnd.getY()) + 1;
        if (rangeMinX <= boxMaxX && rangeMaxX >= boxMinX) {
            minX = Math.max(boxMinX, rangeMinX);
            maxX = Math.min(boxMaxX, rangeMaxX) + 1;
            if (rangeMinZ <= boxMinZ && rangeMaxZ >= boxMinZ) {
                minZ = maxZ = (double)boxMinZ;
                TestUtils.renderWallWithLines((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, lineIntervalH, lineIntervalV, alignLinesToModulo, cameraPos, color, bufferQuads, bufferLines);
            }
            if (rangeMinZ <= boxMaxZ && rangeMaxZ >= boxMaxZ) {
                minZ = maxZ = (double)(boxMaxZ + 1);
                TestUtils.renderWallWithLines((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, lineIntervalH, lineIntervalV, alignLinesToModulo, cameraPos, color, bufferQuads, bufferLines);
            }
        }
        if (rangeMinZ <= boxMaxZ && rangeMaxZ >= boxMinZ) {
            minZ = Math.max(boxMinZ, rangeMinZ);
            maxZ = Math.min(boxMaxZ, rangeMaxZ) + 1;
            if (rangeMinX <= boxMinX && rangeMaxX >= boxMinX) {
                minX = maxX = (double)boxMinX;
                TestUtils.renderWallWithLines((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, lineIntervalH, lineIntervalV, alignLinesToModulo, cameraPos, color, bufferQuads, bufferLines);
            }
            if (rangeMinX <= boxMaxX && rangeMaxX >= boxMaxX) {
                minX = maxX = (double)(boxMaxX + 1);
                TestUtils.renderWallWithLines((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, lineIntervalH, lineIntervalV, alignLinesToModulo, cameraPos, color, bufferQuads, bufferLines);
            }
        }
    }

    public static void renderWallWithLines(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, double lineIntervalH, double lineIntervalV, boolean alignLinesToModulo, Vec3 cameraPos, Color4f color, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        block4: {
            double lineX;
            float cz;
            float cy;
            float cx;
            block5: {
                double lineZ;
                cx = (float)cameraPos.x;
                cy = (float)cameraPos.y;
                cz = (float)cameraPos.z;
                bufferQuads.addVertex(minX - cx, maxY - cy, minZ - cz).setColor(color.r, color.g, color.b, color.a);
                bufferQuads.addVertex(minX - cx, minY - cy, minZ - cz).setColor(color.r, color.g, color.b, color.a);
                bufferQuads.addVertex(maxX - cx, minY - cy, maxZ - cz).setColor(color.r, color.g, color.b, color.a);
                bufferQuads.addVertex(maxX - cx, maxY - cy, maxZ - cz).setColor(color.r, color.g, color.b, color.a);
                if (lineIntervalV > 0.0) {
                    double lineY;
                    double d = lineY = alignLinesToModulo ? TestUtils.roundUp(minY, lineIntervalV) : (double)minY;
                    while (lineY <= (double)maxY) {
                        bufferLines.addVertex(minX - cx, (float)(lineY - (double)cy), minZ - cz).setColor(color.r, color.g, color.b, 1.0f);
                        bufferLines.addVertex(maxX - cx, (float)(lineY - (double)cy), maxZ - cz).setColor(color.r, color.g, color.b, 1.0f);
                        lineY += lineIntervalV;
                    }
                }
                if (!(lineIntervalH > 0.0)) break block4;
                if (minX != maxX) break block5;
                double d = lineZ = alignLinesToModulo ? TestUtils.roundUp(minZ, lineIntervalH) : (double)minZ;
                while (lineZ <= (double)maxZ) {
                    bufferLines.addVertex(minX - cx, minY - cy, (float)(lineZ - (double)cz)).setColor(color.r, color.g, color.b, 1.0f);
                    bufferLines.addVertex(minX - cx, maxY - cy, (float)(lineZ - (double)cz)).setColor(color.r, color.g, color.b, 1.0f);
                    lineZ += lineIntervalH;
                }
                break block4;
            }
            if (minZ != maxZ) break block4;
            double d = lineX = alignLinesToModulo ? TestUtils.roundUp(minX, lineIntervalH) : (double)minX;
            while (lineX <= (double)maxX) {
                bufferLines.addVertex((float)(lineX - (double)cx), minY - cy, minZ - cz).setColor(color.r, color.g, color.b, 1.0f);
                bufferLines.addVertex((float)(lineX - (double)cx), maxY - cy, minZ - cz).setColor(color.r, color.g, color.b, 1.0f);
                lineX += lineIntervalH;
            }
        }
    }

    public static double roundUp(double value, double interval) {
        double remainder;
        if (interval == 0.0) {
            return 0.0;
        }
        if (value == 0.0) {
            return interval;
        }
        if (value < 0.0) {
            interval *= -1.0;
        }
        return (remainder = value % interval) == 0.0 ? value : value + interval - remainder;
    }
}

